// CHECKSTYLE:OFF

package com.sonyericsson.jenkins.plugins.externalresource.dispatcher;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * There is already a reserved resource for this build.
     * 
     */
    public static String BecauseAlreadyReserved() {
        return holder.format("BecauseAlreadyReserved");
    }

    /**
     * There is already a reserved resource for this build.
     * 
     */
    public static Localizable _BecauseAlreadyReserved() {
        return new Localizable(holder, "BecauseAlreadyReserved");
    }

    /**
     * Make an External Resource reservation expired.
     * 
     */
    public static String ExpireExternalResourceCliCommand_Description() {
        return holder.format("ExpireExternalResourceCliCommand_Description");
    }

    /**
     * Make an External Resource reservation expired.
     * 
     */
    public static Localizable _ExpireExternalResourceCliCommand_Description() {
        return new Localizable(holder, "ExpireExternalResourceCliCommand_Description");
    }

    /**
     * Notification regarding locked and released resources.
     * 
     */
    public static String ExternalResource_LockRelease() {
        return holder.format("ExternalResource_LockRelease");
    }

    /**
     * Notification regarding locked and released resources.
     * 
     */
    public static Localizable _ExternalResource_LockRelease() {
        return new Localizable(holder, "ExternalResource_LockRelease");
    }

    /**
     * Failed to {0} the external resource {1} on node {2}!
     * 
     */
    public static String AdminNotifier_ErrorMessage(Object arg1, Object arg2, Object arg3) {
        return holder.format("AdminNotifier_ErrorMessage", arg1, arg2, arg3);
    }

    /**
     * Failed to {0} the external resource {1} on node {2}!
     * 
     */
    public static Localizable _AdminNotifier_ErrorMessage(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "AdminNotifier_ErrorMessage", arg1, arg2, arg3);
    }

    /**
     * No resources on {0} matching the selection criteria.
     * 
     */
    public static String BecauseNoMatchingResource(Object arg1) {
        return holder.format("BecauseNoMatchingResource", arg1);
    }

    /**
     * No resources on {0} matching the selection criteria.
     * 
     */
    public static Localizable _BecauseNoMatchingResource(Object arg1) {
        return new Localizable(holder, "BecauseNoMatchingResource", arg1);
    }

    /**
     * Enable an External Resource.
     * 
     */
    public static String EnableExternalResourceCliCommand_Description() {
        return holder.format("EnableExternalResourceCliCommand_Description");
    }

    /**
     * Enable an External Resource.
     * 
     */
    public static Localizable _EnableExternalResourceCliCommand_Description() {
        return new Localizable(holder, "EnableExternalResourceCliCommand_Description");
    }

    /**
     * Default Manager
     * 
     */
    public static String DefaultExternalResourceManager_DisplayName() {
        return holder.format("DefaultExternalResourceManager_DisplayName");
    }

    /**
     * Default Manager
     * 
     */
    public static Localizable _DefaultExternalResourceManager_DisplayName() {
        return new Localizable(holder, "DefaultExternalResourceManager_DisplayName");
    }

    /**
     * External Resource
     * 
     */
    public static String ExternalResource_DisplayName() {
        return holder.format("ExternalResource_DisplayName");
    }

    /**
     * External Resource
     * 
     */
    public static Localizable _ExternalResource_DisplayName() {
        return new Localizable(holder, "ExternalResource_DisplayName");
    }

    /**
     * Resource Selection
     * 
     */
    public static String SelectionCriteria_DisplayName() {
        return holder.format("SelectionCriteria_DisplayName");
    }

    /**
     * Resource Selection
     * 
     */
    public static Localizable _SelectionCriteria_DisplayName() {
        return new Localizable(holder, "SelectionCriteria_DisplayName");
    }

    /**
     * String
     * 
     */
    public static String StringResourceSelection_DisplayName() {
        return holder.format("StringResourceSelection_DisplayName");
    }

    /**
     * String
     * 
     */
    public static Localizable _StringResourceSelection_DisplayName() {
        return new Localizable(holder, "StringResourceSelection_DisplayName");
    }

    /**
     * None of the matching resources on {0} could be reserved!
     * 
     */
    public static String BecauseNothingReserved(Object arg1) {
        return holder.format("BecauseNothingReserved", arg1);
    }

    /**
     * None of the matching resources on {0} could be reserved!
     * 
     */
    public static Localizable _BecauseNothingReserved(Object arg1) {
        return new Localizable(holder, "BecauseNothingReserved", arg1);
    }

    /**
     * External Resource Monitor Service
     * 
     */
    public static String ResourceMonitorExternalResourceManager_DisplayName() {
        return holder.format("ResourceMonitorExternalResourceManager_DisplayName");
    }

    /**
     * External Resource Monitor Service
     * 
     */
    public static Localizable _ResourceMonitorExternalResourceManager_DisplayName() {
        return new Localizable(holder, "ResourceMonitorExternalResourceManager_DisplayName");
    }

    /**
     * No available resources on {0}.
     * 
     */
    public static String BecauseNoAvailableResources(Object arg1) {
        return holder.format("BecauseNoAvailableResources", arg1);
    }

    /**
     * No available resources on {0}.
     * 
     */
    public static Localizable _BecauseNoAvailableResources(Object arg1) {
        return new Localizable(holder, "BecauseNoAvailableResources", arg1);
    }

    /**
     * Overall permission for external resource handling, grants the other permissions in this group.
     * 
     */
    public static String ExternalResource_Administer() {
        return holder.format("ExternalResource_Administer");
    }

    /**
     * Overall permission for external resource handling, grants the other permissions in this group.
     * 
     */
    public static Localizable _ExternalResource_Administer() {
        return new Localizable(holder, "ExternalResource_Administer");
    }

    /**
     * No Operation
     * 
     */
    public static String NoopExternalResourceManager_DisplayName() {
        return holder.format("NoopExternalResourceManager_DisplayName");
    }

    /**
     * No Operation
     * 
     */
    public static Localizable _NoopExternalResourceManager_DisplayName() {
        return new Localizable(holder, "NoopExternalResourceManager_DisplayName");
    }

    /**
     * Enable/Disable resource.
     * 
     */
    public static String ExternalResource_EnableDisable() {
        return holder.format("ExternalResource_EnableDisable");
    }

    /**
     * Enable/Disable resource.
     * 
     */
    public static Localizable _ExternalResource_EnableDisable() {
        return new Localizable(holder, "ExternalResource_EnableDisable");
    }

    /**
     * Disable an External Resource.
     * 
     */
    public static String DisableExternalResourceCliCommand_Description() {
        return holder.format("DisableExternalResourceCliCommand_Description");
    }

    /**
     * Disable an External Resource.
     * 
     */
    public static Localizable _DisableExternalResourceCliCommand_Description() {
        return new Localizable(holder, "DisableExternalResourceCliCommand_Description");
    }

}
