/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers;

import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import com.sonyericsson.hudson.plugins.metadata.model.values.AbstractMetadataValue;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.Messages;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.Lease;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashResult;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.JsonRpcUtil;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers.ExternalResourceManager;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Node;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;

@Extension
public class ResourceMonitorExternalResourceManager
extends ExternalResourceManager {
    private static final Logger logger = Logger.getLogger(ResourceMonitorExternalResourceManager.class.getName());
    private static final String RESERVE_METHOD = "ResourceMonitor.Resources.Reserve";
    private static final String LOCK_METHOD = "ResourceMonitor.Resources.Lock";
    private static final String RELEASE_METHOD = "ResourceMonitor.Resources.Release";
    private static final String RPC_CALL_URL_TEMPLATE = "http://{0}:{1}/{2}";
    private static final String RESOURCE = "resource";
    private static final String RESERVE_KEY = "key";
    private static final String TIMEOUT = "timeout";
    private static final String CLIENT_INFO = "clientInfo";
    private static final String ID = "id";
    private static final String URL = "url";
    private static final String PORT = "8080";

    private String getURL(Node node) throws IOException, InterruptedException {
        String hostName;
        String nodeURL = null;
        if (null != node && null != (hostName = node.toComputer().getHostName())) {
            nodeURL = MessageFormat.format(RPC_CALL_URL_TEMPLATE, hostName, PORT, "");
        }
        return nodeURL;
    }

    private String getResourceId(ExternalResource resource) {
        return resource.getId();
    }

    @Override
    public String getDisplayName() {
        return Messages.ResourceMonitorExternalResourceManager_DisplayName();
    }

    @Override
    public StashResult doReserve(Node node, ExternalResource resource, int seconds, String reservedBy) {
        RpcResult rpcRes = null;
        String resourceId = this.getResourceId(resource);
        try {
            JsonRpcHttpClient client = JsonRpcUtil.createJsonRpcClient(this.getURL(node), JsonRpcUtil.customizeObjectMapper());
            if (null != client && null != resourceId) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(RESOURCE, resourceId);
                params.put(TIMEOUT, seconds);
                JSONObject clientInfo = new JSONObject();
                clientInfo.put(ID, (Object)Hudson.getInstance().getRootUrl());
                clientInfo.put(URL, (Object)reservedBy);
                params.put(CLIENT_INFO, clientInfo);
                logger.log(Level.FINE, "reserving: {0}", ((Object)params).toString());
                rpcRes = (RpcResult)client.invoke(RESERVE_METHOD, new Object[]{params}, RpcResult.class);
            }
        }
        catch (JsonGenerationException jge) {
            logger.log(Level.WARNING, MessageFormat.format("Can not reserve the resource {0} invalid json generated to rpc call.", resourceId), jge);
        }
        catch (JsonMappingException jme) {
            logger.log(Level.WARNING, MessageFormat.format("Can not reserve the resource {0} invalid json mapping.", resourceId), jme);
        }
        catch (JsonParseException jpre) {
            logger.log(Level.WARNING, MessageFormat.format("Can not reserve the resource {0} failed to parse json.", resourceId), jpre);
        }
        catch (JsonProcessingException jpoe) {
            logger.log(Level.WARNING, MessageFormat.format("Can not reserve the resource {0} failed to process json.", resourceId), jpoe);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, MessageFormat.format("Can not reserve the resource {0}.", resourceId), ioe);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, MessageFormat.format("Can not reserve the resource {0}.", resourceId), e);
        }
        return this.convert(rpcRes);
    }

    @Override
    public StashResult doLock(Node node, ExternalResource resource, String key, String lockedBy) {
        RpcResult rpcRes = null;
        String resourceId = this.getResourceId(resource);
        try {
            JsonRpcHttpClient client = JsonRpcUtil.createJsonRpcClient(this.getURL(node), JsonRpcUtil.customizeObjectMapper());
            if (null != client && null != resourceId) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put(RESOURCE, resourceId);
                params.put(RESERVE_KEY, key);
                JSONObject clientInfo = new JSONObject();
                clientInfo.put(ID, (Object)Hudson.getInstance().getRootUrl());
                clientInfo.put(URL, (Object)lockedBy);
                params.put(CLIENT_INFO, (String)clientInfo);
                logger.log(Level.FINE, "locking: {0}", ((Object)params).toString());
                rpcRes = (RpcResult)client.invoke(LOCK_METHOD, new Object[]{params}, RpcResult.class);
            }
        }
        catch (JsonGenerationException jge) {
            logger.log(Level.WARNING, MessageFormat.format("Can not lock the resource {0} invalid json generated to rpc call.", resourceId), jge);
        }
        catch (JsonMappingException jme) {
            logger.log(Level.WARNING, MessageFormat.format("Can not lock the resource {0} invalid json mapping.", resourceId), jme);
        }
        catch (JsonParseException jpre) {
            logger.log(Level.WARNING, MessageFormat.format("Can not lock the resource {0} failed to parse json.", resourceId), jpre);
        }
        catch (JsonProcessingException jpoe) {
            logger.log(Level.WARNING, MessageFormat.format("Can not lock the resource {0} failed to process json.", resourceId), jpoe);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, MessageFormat.format("Can not lock the resource {0}.", resourceId), ioe);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, MessageFormat.format("Can not lock the resource {0}.", resourceId), e);
        }
        if (rpcRes != null && rpcRes.getKey() == null) {
            rpcRes.setKey(key);
        }
        return this.convert(rpcRes);
    }

    @Override
    public StashResult doRelease(Node node, ExternalResource resource, String key, String releasedBy) {
        RpcResult rpcRes = null;
        String resourceId = this.getResourceId(resource);
        try {
            JsonRpcHttpClient client = JsonRpcUtil.createJsonRpcClient(this.getURL(node));
            if (null != client && null != resourceId) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put(RESOURCE, resourceId);
                params.put(RESERVE_KEY, key);
                JSONObject clientInfo = new JSONObject();
                clientInfo.put(ID, (Object)Hudson.getInstance().getRootUrl());
                clientInfo.put(URL, (Object)releasedBy);
                params.put(CLIENT_INFO, (String)clientInfo);
                logger.log(Level.FINE, "releasing: {0}", ((Object)params).toString());
                rpcRes = (RpcResult)client.invoke(RELEASE_METHOD, new Object[]{params}, RpcResult.class);
            }
        }
        catch (JsonGenerationException jge) {
            logger.log(Level.WARNING, MessageFormat.format("Can not release the resource {0} invalid json generated to rpc call.", resourceId), jge);
        }
        catch (JsonMappingException jme) {
            logger.log(Level.WARNING, MessageFormat.format("Can not release the resource {0} invalid json mapping.", resourceId), jme);
        }
        catch (JsonParseException jpre) {
            logger.log(Level.WARNING, MessageFormat.format("Can not release the resource {0} failed to parse json.", resourceId), jpre);
        }
        catch (JsonProcessingException jpoe) {
            logger.log(Level.WARNING, MessageFormat.format("Can not release the resource {0} failed to process json.", resourceId), jpoe);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, MessageFormat.format("Can not release the resource {0}.", resourceId), ioe);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, MessageFormat.format("Can not release the resource {0}.", resourceId), e);
        }
        return this.convert(rpcRes);
    }

    @Override
    public boolean isExternalLockingOk() {
        return true;
    }

    @Override
    public void updateMetadata(AbstractMetadataValue value) {
    }

    private StashResult convert(RpcResult rpcResult) {
        StashResult targetResult = null;
        Lease lease = null;
        if (null != rpcResult) {
            lease = Lease.createInstance(rpcResult.getTime(), rpcResult.getTimezone(), rpcResult.getIsotime());
            targetResult = new StashResult(rpcResult.getCode(), rpcResult.getMessage(), rpcResult.getKey(), rpcResult.getStatus(), lease);
        }
        return targetResult;
    }

    static class RpcResult {
        private StashResult.Status status;
        private String message;
        private int code;
        private String key;
        private int timezone;
        private long time;
        private String isotime;

        RpcResult() {
        }

        public StashResult.Status getStatus() {
            return this.status;
        }

        public void setStatus(StashResult.Status status) {
            this.status = status;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getTimezone() {
            return this.timezone;
        }

        public void setTimezone(int timezone) {
            this.timezone = timezone;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public String getIsotime() {
            return this.isotime;
        }

        public void setIsotime(String isotime) {
            this.isotime = isotime;
        }
    }
}

