/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers;

import com.sonyericsson.hudson.plugins.metadata.model.values.AbstractMetadataValue;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.Messages;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.cli.ErCliUtils;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashResult;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers.ExternalResourceManager;
import hudson.Extension;
import hudson.model.Node;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.CmdLineException;

@Extension
public class NoopExternalResourceManager
extends ExternalResourceManager {
    protected final StashResult okResult = new StashResult("noop", "noop");

    @Override
    public String getDisplayName() {
        return Messages.NoopExternalResourceManager_DisplayName();
    }

    @Override
    public StashResult doReserve(Node node, ExternalResource resource, int seconds, String reservedBy) {
        Trigger.timer.schedule((TimerTask)new ReservationTimeoutTask(node.getNodeName(), resource.getId()), TimeUnit.SECONDS.toMillis(seconds));
        return this.okResult;
    }

    @Override
    public StashResult doLock(Node node, ExternalResource resource, String key, String lockedBy) {
        return this.okResult;
    }

    @Override
    public StashResult doRelease(Node node, ExternalResource resource, String key, String releasedBy) {
        return this.okResult;
    }

    @Override
    public boolean isExternalLockingOk() {
        return false;
    }

    @Override
    public void updateMetadata(AbstractMetadataValue value) {
    }

    static class ReservationTimeoutTask
    extends TimerTask {
        private static final Logger logger = Logger.getLogger(ReservationTimeoutTask.class.getName());
        private String node;
        private String id;

        ReservationTimeoutTask(String node, String id) {
            this.node = node;
            this.id = id;
        }

        @Override
        public void run() {
            try {
                logger.fine("Reservation timeout.");
                ExternalResource er = ErCliUtils.findExternalResource(this.node, this.id);
                er.doExpireReservation();
            }
            catch (CmdLineException e) {
                logger.log(Level.WARNING, "Failed to timeout a reservation of " + this.id + " on node " + this.node + "!", e);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to save the new reservation state to disk!", e);
            }
        }
    }
}

