/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.selection;

import com.sonyericsson.hudson.plugins.metadata.model.Metadata;
import com.sonyericsson.hudson.plugins.metadata.model.MetadataParent;
import com.sonyericsson.hudson.plugins.metadata.model.values.TreeStructureUtil;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.Messages;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.selection.AbstractResourceSelection;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import org.kohsuke.stapler.DataBoundConstructor;

@XStreamAlias(value="resourceSelection-String")
public class StringResourceSelection
extends AbstractResourceSelection {
    private String name;
    private String value;

    @DataBoundConstructor
    public StringResourceSelection(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Descriptor<AbstractResourceSelection> getDescriptor() {
        return Hudson.getInstance().getDescriptorByType(StringResourceSelectionDescriptor.class);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean equalToExternalResourceValue(ExternalResource externalResource) {
        Object tmpValue;
        String[] path = this.name.split("\\.");
        Metadata externalResourceValue = TreeStructureUtil.getLeaf((MetadataParent)externalResource, (String[])path);
        return externalResourceValue != null && (tmpValue = externalResourceValue.getValue()) != null && this.value.equals(tmpValue.toString());
    }

    @Extension
    public static class StringResourceSelectionDescriptor
    extends AbstractResourceSelection.AbstractResourceSelectionDescriptor {
        public String getDisplayName() {
            return Messages.StringResourceSelection_DisplayName();
        }
    }
}

