/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data;

import java.io.Serializable;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import net.sf.json.JSONObject;

public class Lease
implements Serializable,
Cloneable {
    protected static final int ZERO_PREFIX_THRESHOLD = 10;
    protected static final int NEGATIVE_THRESHOLD = 0;
    private Calendar serverTime;
    private String slaveIsoTime;

    public Lease(Calendar serverTime, String slaveIsoTime) {
        this.serverTime = serverTime;
        this.slaveIsoTime = slaveIsoTime;
    }

    public static Lease createInstance(long slaveTime, int slaveTimeZone, String slaveIsoTime) {
        Calendar calendar = Calendar.getInstance(Lease.createTimeZone(slaveTimeZone));
        calendar.setTimeInMillis(slaveTime);
        Calendar local = Calendar.getInstance();
        local.setTimeInMillis(calendar.getTimeInMillis());
        return new Lease(local, slaveIsoTime);
    }

    private static TimeZone createTimeZone(int timeOffset) {
        String sign = "+";
        if (timeOffset < 0) {
            sign = "-";
            timeOffset *= -1;
        }
        StringBuilder id = new StringBuilder("GMT").append(sign);
        long hours = TimeUnit.SECONDS.toHours(timeOffset);
        long left = (long)timeOffset - TimeUnit.HOURS.toSeconds(hours);
        long minutes = TimeUnit.SECONDS.toMinutes(left);
        if (hours < 10L) {
            id.append('0');
        }
        id.append(hours);
        if (minutes > 0L) {
            id.append(':');
            if (minutes < 10L) {
                id.append('0');
            }
            id.append(minutes);
        }
        return TimeZone.getTimeZone(id.toString());
    }

    public Calendar getServerTime() {
        return this.serverTime;
    }

    public String getSlaveIsoTime() {
        return this.slaveIsoTime;
    }

    public Lease clone() throws CloneNotSupportedException {
        Lease other = (Lease)super.clone();
        other.serverTime = (Calendar)this.serverTime.clone();
        return other;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        JSONObject time = new JSONObject();
        time.put("millis", (Object)this.serverTime.getTimeInMillis());
        time.put("time-zone", (Object)this.serverTime.getTimeZone().getID());
        json.put("server-time", (Object)time);
        json.put("slave-iso-time", (Object)this.slaveIsoTime);
        return json;
    }
}

