/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data;

import com.sonyericsson.hudson.plugins.metadata.model.JsonUtils;
import com.sonyericsson.hudson.plugins.metadata.model.MetadataContainer;
import com.sonyericsson.hudson.plugins.metadata.model.values.AbstractMetadataValue;
import com.sonyericsson.hudson.plugins.metadata.model.values.MetadataValue;
import com.sonyericsson.hudson.plugins.metadata.model.values.TreeNodeMetadataValue;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.Messages;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.PluginImpl;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers.DefaultExternalResourceManager;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers.ExternalResourceManager;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ExternalResourceTreeNode
extends TreeNodeMetadataValue {
    private ExternalResourceManager manager;

    @DataBoundConstructor
    public ExternalResourceTreeNode(String name, String description, List<MetadataValue> children, String managerName, boolean exposedToEnvironment) {
        super(name, description, children, exposedToEnvironment);
        ExternalResourceManager dynamic;
        this.manager = dynamic = (ExternalResourceManager)PluginImpl.getInstance().getAvailableExternalResourceManagers().getDynamic(managerName);
    }

    public ExternalResourceTreeNode(String name, String description, List<MetadataValue> children, boolean exposedToEnvironment) {
        super(name, description, children, exposedToEnvironment);
    }

    public ExternalResourceTreeNode(String name, String description, List<MetadataValue> children) {
        super(name, description, children);
    }

    public ExternalResourceTreeNode(String name, String description) {
        super(name, description);
    }

    public ExternalResourceTreeNode(String name, List<MetadataValue> children) {
        super(name, children);
    }

    public ExternalResourceTreeNode(String name) {
        super(name);
    }

    public ExternalResourceManager getManager() {
        return this.manager;
    }

    public Descriptor<AbstractMetadataValue> getDescriptor() {
        return Hudson.getInstance().getDescriptorByType(ExternalResourceTreeNodeDescriptor.class);
    }

    public ExternalResourceManager findManager() {
        if (this.manager != null) {
            return this.manager;
        }
        return PluginImpl.getInstance().getManager();
    }

    @Extension
    public static class ExternalResourceTreeNodeDescriptor
    extends AbstractMetadataValue.AbstractMetaDataValueDescriptor {
        public String getJsonType() {
            return "externalresource-treenode";
        }

        public MetadataValue fromJson(JSONObject json, MetadataContainer<MetadataValue> container) throws JsonUtils.ParseException {
            return null;
        }

        public String getDisplayName() {
            return "External Resource TreeNode";
        }

        public List<ExternalResourceManager> getAvailableExternalResourceManagers() {
            LinkedList<ExternalResourceManager> list = new LinkedList<ExternalResourceManager>();
            ExtensionList<ExternalResourceManager> availableExternalResourceManagers = PluginImpl.getInstance().getAvailableExternalResourceManagers();
            for (ExternalResourceManager manager : availableExternalResourceManagers) {
                list.add(manager);
            }
            list.add(new DefaultExternalResourceManager());
            return list;
        }

        public List<AbstractMetadataValue.AbstractMetaDataValueDescriptor> getValueDescriptors(StaplerRequest request) {
            LinkedList<AbstractMetadataValue.AbstractMetaDataValueDescriptor> list = new LinkedList<AbstractMetadataValue.AbstractMetaDataValueDescriptor>();
            ExtensionList extensionList = Hudson.getInstance().getExtensionList(ExternalResource.ExternalResourceDescriptor.class);
            list.addAll((Collection<AbstractMetadataValue.AbstractMetaDataValueDescriptor>)extensionList);
            return list;
        }

        public String getDefaultManagerDisplayName() {
            return Messages.DefaultExternalResourceManager_DisplayName();
        }
    }
}

