/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.cli;

import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.cli.ErCliUtils;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashInfo;
import hudson.Extension;
import hudson.cli.CLICommand;
import java.util.logging.Logger;
import org.kohsuke.args4j.Option;

@Extension
public class LockExternalResourceCommand
extends CLICommand {
    private static final Logger logger = Logger.getLogger(LockExternalResourceCommand.class.getName());
    @Option(required=true, name="-node", usage="The name of the node")
    public String nodeName;
    @Option(required=true, name="-id", usage="The id of the external resource")
    public String id;
    @Option(required=true, name="-lockedBy", usage="Information text to Jenkins detailing who locked the resource")
    public String lockedBy;
    @Option(required=true, name="-clientInfo", usage="Information regarding the client that locked the resource")
    public String clientInfo;

    public String getShortDescription() {
        return "Locks an external resource.";
    }

    protected int run() throws Exception {
        if (ErCliUtils.isRequestCircular(this.clientInfo)) {
            return 0;
        }
        ExternalResource er = ErCliUtils.findExternalResource(this.nodeName, this.id);
        StashInfo lockedInfo = new StashInfo(StashInfo.StashType.EXTERNAL, this.lockedBy, null, null);
        er.doLock(lockedInfo);
        return 0;
    }
}

