/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher;

import com.sonyericsson.hudson.plugins.metadata.model.MetadataBuildAction;
import com.sonyericsson.hudson.plugins.metadata.model.MetadataParent;
import com.sonyericsson.hudson.plugins.metadata.model.values.MetadataValue;
import com.sonyericsson.hudson.plugins.metadata.model.values.TreeStructureUtil;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.Constants;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.PluginImpl;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashInfo;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashResult;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.AdminNotifier;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.AvailabilityFilter;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class ReleaseRunListener
extends RunListener<AbstractBuild> {
    private static final Logger logger = Logger.getLogger(ReleaseRunListener.class.getName());

    public void onCompleted(AbstractBuild build, TaskListener listener) {
        logger.entering("ReleaseRunListener", "onCompleted", build);
        MetadataBuildAction metadata = (MetadataBuildAction)build.getAction(MetadataBuildAction.class);
        if (metadata != null) {
            MetadataValue value = (MetadataValue)TreeStructureUtil.getPath((MetadataParent)metadata, (String[])Constants.getBuildLockedResourcePath());
            if (value != null && value instanceof ExternalResource) {
                ExternalResource buildResource = (ExternalResource)value;
                PrintStream buildLogger = listener.getLogger();
                this.release(build, buildResource, buildLogger);
            } else {
                logger.log(Level.FINE, "No locked resource found: {0}", value);
            }
        } else {
            logger.log(Level.FINE, "No metadata attached to build {0}.", build);
        }
        logger.exiting("ReleaseRunListener", "onCompleted");
    }

    private void release(AbstractBuild build, ExternalResource buildResource, PrintStream buildLogger) {
        buildLogger.println("Releasing previously locked resource: " + buildResource.getId() + "...");
        logger.log(Level.FINE, "Releasing previously locked resource: [{0}] for build [{1}]", new String[]{buildResource.getId(), build.getFullDisplayName()});
        ExternalResource nodeResource = AvailabilityFilter.getInstance().getExternalResourceById(build.getBuiltOn(), buildResource.getId());
        if (nodeResource != null) {
            StashInfo lockInfo = nodeResource.getLocked();
            if (lockInfo != null) {
                StashResult result = PluginImpl.getInstance().getManager().release(build.getBuiltOn(), nodeResource, lockInfo.getKey(), build.getUrl());
                if (result != null && result.isOk()) {
                    this.logReleaseSuccess(build, buildResource, buildLogger);
                } else {
                    this.logReleaseFailure(build, buildLogger, nodeResource, result);
                }
            } else {
                this.logWarningPreReleased(build, buildLogger, nodeResource);
            }
        } else {
            this.logNoLongerAttached(build, buildResource, buildLogger);
        }
        buildResource.setLocked(null);
    }

    private void logNoLongerAttached(AbstractBuild build, ExternalResource buildResource, PrintStream buildLogger) {
        AdminNotifier.getInstance().notify(AdminNotifier.MessageType.WARNING, AdminNotifier.OperationType.RELEASE, build.getBuiltOn(), buildResource, "The external resource is no longer attached to the node. Skipping release");
        buildLogger.println("The external resource is no longer attached to the node. Skipping release");
        logger.log(Level.WARNING, "The external resource [{0}] is no longer attached to the node [{1}]. Skipping release.", new String[]{buildResource.getId(), build.getBuiltOn().getNodeName()});
    }

    private void logWarningPreReleased(AbstractBuild build, PrintStream buildLogger, ExternalResource nodeResource) {
        AdminNotifier.getInstance().notify(AdminNotifier.MessageType.WARNING, AdminNotifier.OperationType.RELEASE, build.getBuiltOn(), nodeResource, "The resource has already been unlocked by some other means");
        buildLogger.println("WARNING The resource has already been unlocked by some other means. The Build might have suffered from it.");
        logger.log(Level.WARNING, "The resource [{0}] on node [{1}] has already been unlocked by some other means", new String[]{nodeResource.getId(), build.getBuiltOn().getNodeName()});
    }

    private void logReleaseSuccess(AbstractBuild build, ExternalResource buildResource, PrintStream buildLogger) {
        buildLogger.println("Resource " + buildResource.getId() + " successfully released.");
        logger.log(Level.FINE, "Resource [{0}] successfully released from build [{1}]", new String[]{buildResource.getId(), build.getFullDisplayName()});
    }

    private void logReleaseFailure(AbstractBuild build, PrintStream buildLogger, ExternalResource nodeResource, StashResult result) {
        buildLogger.println("ERROR Failed to release resource " + nodeResource.getId());
        if (result != null) {
            AdminNotifier.getInstance().notify(AdminNotifier.MessageType.ERROR, AdminNotifier.OperationType.RELEASE, build.getBuiltOn(), nodeResource, "Failed to release external resource from build: " + build.getFullDisplayName() + " Status: " + (Object)((Object)result.getStatus()) + ", Code: " + result.getErrorCode() + ", Message: " + result.getMessage());
            buildLogger.println("\tStatus: " + (Object)((Object)result.getStatus()) + " Code: " + result.getErrorCode() + " Message: " + result.getMessage());
            logger.log(Level.SEVERE, "Failed to release resource [{0}] from build [{1}]: Status: {2}, Code: {3}, Message: {4}", new Object[]{nodeResource.getId(), build.getFullDisplayName(), result.getStatus(), result.getErrorCode(), result.getMessage()});
        } else {
            AdminNotifier.getInstance().notify(AdminNotifier.MessageType.ERROR, AdminNotifier.OperationType.RELEASE, build.getBuiltOn(), nodeResource, "Failed to release external resource  from build:" + build.getFullDisplayName() + "No result!");
            logger.log(Level.SEVERE, "Failed to release resource [{0}] from build [{1}]: No Result!", new Object[]{nodeResource.getId(), build.getFullDisplayName()});
        }
    }
}

