/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher;

import com.sonyericsson.hudson.plugins.metadata.MetadataUpdateListener;
import com.sonyericsson.hudson.plugins.metadata.model.MetadataNodeProperty;
import com.sonyericsson.hudson.plugins.metadata.model.MetadataParent;
import com.sonyericsson.hudson.plugins.metadata.model.values.AbstractMetadataValue;
import com.sonyericsson.hudson.plugins.metadata.model.values.MetadataValue;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResourceTreeNode;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers.ExternalResourceManager;
import hudson.Extension;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

@Extension
public class ExternalResourceMetadataUpdateListener
extends MetadataUpdateListener {
    public void metadataNodePropertyChanged(MetadataNodeProperty property) {
        List<ExternalResourceTreeNode> forest = this.findExternalResourceTreeNodes((MetadataParent<MetadataValue>)property);
        for (ExternalResourceTreeNode tree : forest) {
            ExternalResourceManager manager = tree.findManager();
            manager.updateMetadata((AbstractMetadataValue)tree);
        }
    }

    private List<ExternalResourceTreeNode> findExternalResourceTreeNodes(MetadataParent<MetadataValue> property) {
        LinkedList<ExternalResourceTreeNode> treeNodes = new LinkedList<ExternalResourceTreeNode>();
        if (property != null) {
            Collection children = property.getChildren();
            for (MetadataValue child : children) {
                if (child instanceof ExternalResourceTreeNode) {
                    treeNodes.add((ExternalResourceTreeNode)child);
                    continue;
                }
                if (!(child instanceof MetadataParent)) continue;
                treeNodes.addAll(this.findExternalResourceTreeNodes((MetadataParent<MetadataValue>)((MetadataParent)child)));
            }
        }
        return treeNodes;
    }
}

