/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.sonyericsson.jenkins.plugins.bfa.CauseManagement;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import net.vz.mongodb.jackson.Id;
import net.vz.mongodb.jackson.ObjectId;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonIgnoreType;
import org.codehaus.jackson.annotate.JsonProperty;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FailureCause
implements Serializable,
Action,
Describable<FailureCause> {
    private static final Logger logger = Logger.getLogger(FailureCause.class.getName());
    private String id;
    private String name;
    private String description;
    private List<String> categories;
    private List<Indication> indications;

    @DataBoundConstructor
    public FailureCause(String id, String name, String description, String categories, List<Indication> indications) {
        this(id, name, description, Arrays.asList(Util.tokenize((String)categories)), indications);
    }

    @JsonCreator
    public FailureCause(@Id @ObjectId String id, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="categories") List<String> categories, @JsonProperty(value="indications") List<Indication> indications) {
        this.id = Util.fixEmpty((String)id);
        this.name = name;
        this.description = description;
        this.categories = categories;
        this.indications = indications;
        if (this.indications == null) {
            this.indications = new LinkedList<Indication>();
        }
    }

    public FailureCause(String name, String description) {
        this(null, name, description, "", null);
    }

    public FailureCause() {
    }

    public FormValidation validate(String newName, String newDescription, List<Indication> newIndications) {
        FormValidation nameVal = this.doCheckName(newName);
        if (nameVal.kind != FormValidation.Kind.OK) {
            return nameVal;
        }
        FormValidation descriptionVal = this.doCheckDescription(newDescription);
        if (descriptionVal.kind != FormValidation.Kind.OK) {
            return descriptionVal;
        }
        if (newIndications == null || newIndications.isEmpty()) {
            return FormValidation.error((String)("Need at least one indication for " + newName));
        }
        for (Indication indication : newIndications) {
            FormValidation validation = indication.validate();
            if (validation.kind == FormValidation.Kind.OK) continue;
            return validation;
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckDescription(@QueryParameter String value) {
        if (Util.fixEmpty((String)value) == null) {
            return FormValidation.error((String)"You should provide a description.");
        }
        if ("Description...".equalsIgnoreCase(value.trim())) {
            return FormValidation.error((String)"Bad description.");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckName(@QueryParameter String value) {
        if (Util.fixEmpty((String)value) == null) {
            return FormValidation.error((String)"You must provide a name for the failure cause!");
        }
        if ("New...".equalsIgnoreCase(value)) {
            return FormValidation.error((String)"Reserved name!");
        }
        try {
            Jenkins.checkGoodName((String)value);
        }
        catch (Failure failure) {
            return FormValidation.error((Throwable)failure, (String)failure.getMessage());
        }
        try {
            for (FailureCause other : PluginImpl.getInstance().getKnowledgeBase().getCauses()) {
                if (this.id != null && this.id.equals(other.getId()) || !value.equals(other.getName())) continue;
                return FormValidation.error((String)"There is another cause with that name.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get causes list to evaluate name! ", e);
        }
        return FormValidation.ok();
    }

    public synchronized void doConfigSubmit(StaplerRequest request, StaplerResponse response) throws Exception {
        logger.entering(this.getClass().getName(), "doConfigSubmit");
        Jenkins.getInstance().checkPermission(PluginImpl.UPDATE_PERMISSION);
        JSONObject form = request.getSubmittedForm();
        String newId = form.getString("id");
        newId = Util.fixEmpty((String)newId);
        String oldId = Util.fixEmpty((String)this.id);
        if (newId != null) {
            if (oldId != null && !newId.equals(oldId)) {
                throw new Failure("Attempt at changing the wrong cause! Expected [" + this.id + "] but got [" + newId + "]");
            }
            if (oldId == null) {
                throw new Failure("Attempt at setting id of new cause!");
            }
        } else if (oldId != null) {
            throw new Failure("Clone attempt of cause [" + this.id + "]");
        }
        String newName = form.getString("name");
        String newDescription = form.getString("description");
        String jsonCategories = form.optString("categories");
        this.categories = Util.fixEmpty((String)jsonCategories) != null ? Arrays.asList(Util.tokenize((String)jsonCategories)) : null;
        Object jsonIndications = form.opt("indications");
        if (jsonIndications == null) {
            throw new Failure("You need to provide at least one indication!");
        }
        List newIndications = request.bindJSONToList(Indication.class, jsonIndications);
        FormValidation validation = this.validate(newName, newDescription, newIndications);
        if (validation.kind != FormValidation.Kind.OK) {
            throw validation;
        }
        this.name = newName;
        this.description = newDescription;
        this.indications = newIndications;
        if (newId == null) {
            PluginImpl.getInstance().getKnowledgeBase().addCause(this);
        } else {
            PluginImpl.getInstance().getKnowledgeBase().saveCause(this);
        }
        response.sendRedirect2("../");
    }

    public void addIndication(Indication indication) {
        if (this.indications == null) {
            this.indications = new LinkedList<Indication>();
        }
        this.indications.add(indication);
    }

    @Id
    @ObjectId
    public String getId() {
        return this.id;
    }

    @Id
    @ObjectId
    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    @JsonIgnore
    public String getCategoriesAsString() {
        if (this.categories == null || this.categories.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String item : this.categories) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public List<Indication> getIndications() {
        if (this.indications == null) {
            this.indications = new LinkedList<Indication>();
        }
        return this.indications;
    }

    @JsonIgnore
    public CauseManagement getAncestorCauseManagement() {
        CauseManagement ancestorObject = (CauseManagement)Stapler.getCurrentRequest().findAncestorObject(CauseManagement.class);
        if (ancestorObject != null) {
            return ancestorObject;
        }
        throw new IllegalStateException("getAncestorCauseManagement must be called within the scope of a StaplerRequest with a CauseManagement ancestor!");
    }

    @JsonIgnore
    public String getIconFileName() {
        return PluginImpl.getDefaultIcon();
    }

    @JsonIgnore
    public String getDisplayName() {
        return this.name;
    }

    @JsonIgnore
    public String getUrlName() {
        return this.id;
    }

    public FailureCauseDescriptor getDescriptor() {
        return (FailureCauseDescriptor)Jenkins.getInstance().getDescriptorByType(FailureCauseDescriptor.class);
    }

    @Extension
    @JsonIgnoreType
    public static final class FailureCauseDescriptor
    extends Descriptor<FailureCause> {
        public String getDisplayName() {
            return null;
        }

        public AutoCompletionCandidates doAutoCompleteCategories(@QueryParameter String value) {
            List<String> categories;
            try {
                categories = PluginImpl.getInstance().getKnowledgeBase().getCategories();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not get the categories for autocompletion", e);
                return null;
            }
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            if (categories == null) {
                return candidates;
            }
            for (String category : categories) {
                if (!category.toLowerCase().startsWith(value.toLowerCase())) continue;
                candidates.add(category);
            }
            return candidates;
        }
    }
}

