/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.FailureScanner;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class FailureScannerProvisioner
extends RunListener<AbstractBuild> {
    private static final Logger logger = Logger.getLogger(FailureScannerProvisioner.class.getName());

    public void onStarted(AbstractBuild build, TaskListener listener) {
        if (PluginImpl.shouldScan(build) && build.getProject().getPublishersList().get(FailureScanner.class) == null) {
            try {
                build.getProject().getPublishersList().add((Object)new FailureScanner());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to add a FailureScanner to " + build.getProject().getFullDisplayName(), e);
                listener.getLogger().println("[BFA] WARNING! Failed to add the scanner to this job, failure analysis will not be performed.");
            }
        }
    }
}

