/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.FailureCauseMatrixAggregator;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import com.sonyericsson.jenkins.plugins.bfa.statistics.StatisticsLogger;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FailureScanner
extends Notifier
implements MatrixAggregatable {
    private static final Logger logger = Logger.getLogger(FailureScanner.class.getName());

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener buildListener) {
        if (PluginImpl.shouldScan(build) && build.getResult().isWorseThan(Result.SUCCESS)) {
            try {
                PrintStream buildLog = buildListener.getLogger();
                Collection<FailureCause> causes = PluginImpl.getInstance().getKnowledgeBase().getCauses();
                List<FoundFailureCause> foundCauseList = this.findCauses(causes, build, buildLog);
                FailureCauseBuildAction buildAction = new FailureCauseBuildAction(foundCauseList);
                build.addAction((Action)buildAction);
                StatisticsLogger.getInstance().log(build, foundCauseList);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not get the causes from the knowledge base", e);
                return false;
            }
        }
        return true;
    }

    private List<FoundFailureCause> findCauses(Collection<FailureCause> causes, final AbstractBuild build, final PrintStream buildLog) {
        final List<FoundFailureCause> foundFailureCauseList = Collections.synchronizedList(new LinkedList());
        long start = System.currentTimeMillis();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(PluginImpl.getInstance().getNrOfScanThreads());
        buildLog.println("[BFA] Scanning build for known causes...");
        for (final FailureCause cause : causes) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    List foundIndications = FailureScanner.this.findIndications(cause, build, buildLog);
                    if (!foundIndications.isEmpty()) {
                        FoundFailureCause foundFailureCause = new FoundFailureCause(cause);
                        foundFailureCause.addIndications(foundIndications);
                        foundFailureCauseList.add(foundFailureCause);
                    }
                }
            });
        }
        executor.shutdown();
        try {
            while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                buildLog.print('.');
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.FINE, "Got interrupted while waiting for scanner threads to finish for {0}", build.getFullDisplayName());
            buildLog.println("[BFA] Interrupted.");
        }
        long time = System.currentTimeMillis() - start;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[BFA] [{0}] {1}ms", new Object[]{build.getFullDisplayName(), String.valueOf(time)});
        }
        buildLog.println();
        buildLog.println("[BFA] Done. " + TimeUnit.MILLISECONDS.toSeconds(time) + "s");
        return foundFailureCauseList;
    }

    private List<FoundIndication> findIndications(FailureCause cause, AbstractBuild build, PrintStream buildLog) {
        long start = System.currentTimeMillis();
        List<Indication> indicationList = cause.getIndications();
        LinkedList<FoundIndication> foundIndicationList = new LinkedList<FoundIndication>();
        for (Indication indication : indicationList) {
            FoundIndication foundIndication = this.findIndication(indication, build, buildLog);
            if (foundIndication == null) continue;
            foundIndicationList.add(foundIndication);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[BFA] [{0}] [{1}] {2}ms", new Object[]{build.getFullDisplayName(), cause.getName(), String.valueOf(System.currentTimeMillis() - start)});
        }
        return foundIndicationList;
    }

    private FoundIndication findIndication(Indication indication, AbstractBuild build, PrintStream buildLog) {
        FailureReader failureReader = indication.getReader();
        return failureReader.scan(build, buildLog);
    }

    public FailureScannerDescriptor getDescriptor() {
        return (FailureScannerDescriptor)Hudson.getInstance().getDescriptorByType(FailureScannerDescriptor.class);
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new FailureCauseMatrixAggregator(build, launcher, listener);
    }

    public static final class FailureScannerDescriptor
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }
    }
}

