/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.wasPlugin.QualysClient;

import com.qualys.plugins.wasPlugin.QualysAuth.QualysAuth;
import com.qualys.plugins.wasPlugin.util.Helper;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.util.EntityUtils;

class QualysBaseClient {
    private QualysAuth auth;
    protected PrintStream stream;
    protected int timeout = 30;
    private static final String oAuthEndpoint = "/auth/oidc";

    public QualysBaseClient(QualysAuth auth) {
        this.auth = auth;
        this.stream = System.out;
    }

    public QualysBaseClient(QualysAuth auth, PrintStream stream) {
        this.auth = auth;
        this.stream = stream;
    }

    public URL getAbsoluteUrl(String path) throws MalformedURLException {
        path = ((String)path).startsWith("/") ? path : "/" + (String)path;
        URL url = new URL(this.auth.getServer() + (String)path);
        return url;
    }

    protected String getBasicAuthHeader() {
        String userPass = this.auth.getUsername() + ":" + this.auth.getPassword();
        String encoded = Base64.getEncoder().encodeToString(userPass.getBytes(StandardCharsets.UTF_8));
        return encoded;
    }

    protected CloseableHttpClient getHttpClient() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.timeout * 1000).setConnectionRequestTimeout(this.timeout * 1000).setSocketTimeout(this.timeout * 1000).build();
        SSLContextBuilder builder = new SSLContextBuilder();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
        HttpClientBuilder clientBuilder = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        clientBuilder.setDefaultRequestConfig(config);
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        if (this.auth.getProxyServer() != null && !this.auth.getProxyServer().isEmpty()) {
            HttpHost proxyHost = new HttpHost(this.auth.getProxyServer(), this.auth.getProxyPort());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
            clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            String username = this.auth.getProxyUsername();
            String password = this.auth.getProxyPassword();
            if (username != null && !"".equals(username.trim())) {
                System.out.println("Using proxy authentication (user=" + username + ")");
                credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        return clientBuilder.build();
    }

    protected String sendGetRequest(CloseableHttpClient httpClient, String url, Map<String, String> headers) throws IOException {
        HttpGet getRequest = new HttpGet(url);
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((HttpGet)getRequest).addHeader(arg_0, arg_1));
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getRequest);){
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode >= 200 && statusCode < 300) {
                String string = responseBody;
                return string;
            }
            throw new IOException("GET request failed with status code " + statusCode + ": " + responseBody);
        }
    }

    protected String sendPostRequest(CloseableHttpClient httpClient, String url, Map<String, String> headers, String body) throws IOException {
        HttpPost postRequest = new HttpPost(url);
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((HttpPost)postRequest).addHeader(arg_0, arg_1));
        }
        if (body != null && !body.isEmpty()) {
            postRequest.setEntity((HttpEntity)new StringEntity(body));
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);){
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode >= 200 && statusCode < 300) {
                String string = responseBody;
                return string;
            }
            String string = null;
            return string;
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected String getAuthorizationHeader() {
        if (String.valueOf((Object)this.auth.getAuthType()).equalsIgnoreCase("BASIC")) {
            return "Basic " + this.getBasicAuthHeader();
        }
        if (String.valueOf((Object)this.auth.getAuthType()).equalsIgnoreCase("OAUTH")) {
            return "Bearer " + this.generateJwtTokenUsingClientIdAndClientSecret();
        }
        return null;
    }

    protected Map<String, String> getOauthHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", "application/json");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("clientId", this.auth.getClientId());
        headers.put("clientSecret", this.auth.getClientSecret());
        return headers;
    }

    protected Map<String, String> getCommonHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", "application/json");
        headers.put("Authorization", this.getAuthorizationHeader());
        if (String.valueOf((Object)this.auth.getAuthType()).equalsIgnoreCase("OAUTH")) {
            headers.put("request-source", "gateway");
        }
        return headers;
    }

    public String generateJwtTokenUsingClientIdAndClientSecret() {
        String apiUrl = Helper.getGatewayUrl(this.auth.getServer()) + oAuthEndpoint;
        System.out.println("Requesting new auth token using clientId and clientSecret from API Gateway Server:" + apiUrl);
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.getHttpClient();
            String response = this.sendPostRequest(httpClient, apiUrl, this.getOauthHeaders(), null);
            if (response != null) {
                System.out.println("Successfully received auth token from API Gateway Server.");
                return response;
            }
            System.out.println("Error while generating JWT token.");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            System.out.println("Error while generating JWT token " + e.getMessage());
        }
        return null;
    }
}

