/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.wasPlugin.QualysAuth;

import com.qualys.plugins.wasPlugin.QualysAuth.AuthType;
import hudson.util.Secret;

public class QualysAuth {
    private AuthType authType;
    private String server;
    private String username;
    private Secret password;
    private String authKey;
    private String proxyServer;
    private String proxyUsername;
    private Secret proxyPassword;
    private int proxyPort;
    private String clientId;
    private String clientSecret;

    public QualysAuth() {
    }

    public QualysAuth(String server, String oauthKey) {
        this.authKey = oauthKey;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getServer() {
        return this.server;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password.getPlainText();
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword.getPlainText();
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setQualysCredentials(String server, String username, String password) {
        this.server = server;
        this.username = username;
        this.password = Secret.fromString((String)password);
    }

    public void setQualysCredentials(String server, AuthType authType, String username, String password, String clientId, String clientSecret) {
        this.authType = authType;
        this.server = server;
        this.username = username;
        this.password = Secret.fromString((String)password);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public void setProxyCredentials(String proxyServer, int proxyPort, String proxyUsername, String proxyPassword) {
        this.proxyServer = proxyServer;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = Secret.fromString((String)proxyPassword);
        this.proxyPort = proxyPort;
    }
}

