/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.jenkins.coverage.model;

import com.parasoft.findings.jenkins.coverage.model.FileNode;
import com.parasoft.findings.jenkins.coverage.model.MethodNode;
import com.parasoft.findings.jenkins.coverage.model.Metric;
import com.parasoft.findings.jenkins.coverage.model.Node;
import com.parasoft.findings.jenkins.coverage.model.Value;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class NodeAssert
extends AbstractObjectAssert<NodeAssert, Node> {
    public NodeAssert(Node actual) {
        super((Object)actual, NodeAssert.class);
    }

    @CheckReturnValue
    public static NodeAssert assertThat(Node actual) {
        return new NodeAssert(actual);
    }

    public NodeAssert hasAllFileNodes(FileNode ... allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllFileNodes(), (Object[])allFileNodes);
        return this;
    }

    public NodeAssert hasAllFileNodes(Collection<? extends FileNode> allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllFileNodes(), allFileNodes.toArray());
        return this;
    }

    public NodeAssert hasOnlyAllFileNodes(FileNode ... allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllFileNodes(), (Object[])allFileNodes);
        return this;
    }

    public NodeAssert hasOnlyAllFileNodes(Collection<? extends FileNode> allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllFileNodes(), allFileNodes.toArray());
        return this;
    }

    public NodeAssert doesNotHaveAllFileNodes(FileNode ... allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllFileNodes(), (Object[])allFileNodes);
        return this;
    }

    public NodeAssert doesNotHaveAllFileNodes(Collection<? extends FileNode> allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllFileNodes(), allFileNodes.toArray());
        return this;
    }

    public NodeAssert hasNoAllFileNodes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allFileNodes but had :\n  <%s>";
        if (((Node)this.actual).getAllFileNodes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Node)this.actual).getAllFileNodes()});
        }
        return this;
    }

    public NodeAssert hasAllMethodNodes(MethodNode ... allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllMethodNodes(), (Object[])allMethodNodes);
        return this;
    }

    public NodeAssert hasAllMethodNodes(Collection<? extends MethodNode> allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllMethodNodes(), allMethodNodes.toArray());
        return this;
    }

    public NodeAssert hasOnlyAllMethodNodes(MethodNode ... allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllMethodNodes(), (Object[])allMethodNodes);
        return this;
    }

    public NodeAssert hasOnlyAllMethodNodes(Collection<? extends MethodNode> allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllMethodNodes(), allMethodNodes.toArray());
        return this;
    }

    public NodeAssert doesNotHaveAllMethodNodes(MethodNode ... allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllMethodNodes(), (Object[])allMethodNodes);
        return this;
    }

    public NodeAssert doesNotHaveAllMethodNodes(Collection<? extends MethodNode> allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getAllMethodNodes(), allMethodNodes.toArray());
        return this;
    }

    public NodeAssert hasNoAllMethodNodes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allMethodNodes but had :\n  <%s>";
        if (((Node)this.actual).getAllMethodNodes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Node)this.actual).getAllMethodNodes()});
        }
        return this;
    }

    public NodeAssert hasChildren(Node ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public NodeAssert hasChildren(Collection<? extends Node> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getChildren(), children.toArray());
        return this;
    }

    public NodeAssert hasOnlyChildren(Node ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public NodeAssert hasOnlyChildren(Collection<? extends Node> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getChildren(), children.toArray());
        return this;
    }

    public NodeAssert doesNotHaveChildren(Node ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public NodeAssert doesNotHaveChildren(Collection<? extends Node> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getChildren(), children.toArray());
        return this;
    }

    public NodeAssert hasNoChildren() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have children but had :\n  <%s>";
        if (((Node)this.actual).getChildren().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Node)this.actual).getChildren()});
        }
        return this;
    }

    public NodeAssert hasChildren() {
        this.isNotNull();
        if (!((Node)this.actual).hasChildren()) {
            this.failWithMessage("\nExpecting that actual Node has children but does not have.", new Object[0]);
        }
        return this;
    }

    public NodeAssert doesNotHaveChildren() {
        this.isNotNull();
        if (((Node)this.actual).hasChildren()) {
            this.failWithMessage("\nExpecting that actual Node does not have children but has.", new Object[0]);
        }
        return this;
    }

    public NodeAssert isEmpty() {
        this.isNotNull();
        if (!((Node)this.actual).isEmpty()) {
            this.failWithMessage("\nExpecting that actual Node is empty but is not.", new Object[0]);
        }
        return this;
    }

    public NodeAssert isNotEmpty() {
        this.isNotNull();
        if (((Node)this.actual).isEmpty()) {
            this.failWithMessage("\nExpecting that actual Node is not empty but is.", new Object[0]);
        }
        return this;
    }

    public NodeAssert hasFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public NodeAssert hasFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getFiles(), files.toArray());
        return this;
    }

    public NodeAssert hasOnlyFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public NodeAssert hasOnlyFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getFiles(), files.toArray());
        return this;
    }

    public NodeAssert doesNotHaveFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public NodeAssert doesNotHaveFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getFiles(), files.toArray());
        return this;
    }

    public NodeAssert hasNoFiles() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have files but had :\n  <%s>";
        if (((Node)this.actual).getFiles().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Node)this.actual).getFiles()});
        }
        return this;
    }

    public NodeAssert hasMetric(Metric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Metric actualMetric = ((Node)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }

    public NodeAssert hasMetrics(Metric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public NodeAssert hasMetrics(Collection<? extends Metric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public NodeAssert hasOnlyMetrics(Metric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public NodeAssert hasOnlyMetrics(Collection<? extends Metric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public NodeAssert doesNotHaveMetrics(Metric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public NodeAssert doesNotHaveMetrics(Collection<? extends Metric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public NodeAssert hasNoMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have metrics but had :\n  <%s>";
        if (((Node)this.actual).getMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Node)this.actual).getMetrics()});
        }
        return this;
    }

    public NodeAssert hasModifiedLines() {
        this.isNotNull();
        if (!((Node)this.actual).hasModifiedLines()) {
            this.failWithMessage("\nExpecting that actual Node has modified lines but does not have.", new Object[0]);
        }
        return this;
    }

    public NodeAssert doesNotHaveModifiedLines() {
        this.isNotNull();
        if (((Node)this.actual).hasModifiedLines()) {
            this.failWithMessage("\nExpecting that actual Node does not have modified lines but has.", new Object[0]);
        }
        return this;
    }

    public NodeAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((Node)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public NodeAssert hasParasoftToolName(String parasoftToolName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parasoftToolName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualParasoftToolName = ((Node)this.actual).getParasoftToolName();
        if (!Objects.deepEquals(actualParasoftToolName, parasoftToolName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parasoftToolName, actualParasoftToolName});
        }
        return this;
    }

    public NodeAssert hasParent(Node parent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Node actualParent = ((Node)this.actual).getParent();
        if (!Objects.deepEquals(actualParent, parent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parent, actualParent});
        }
        return this;
    }

    public NodeAssert hasParent() {
        this.isNotNull();
        if (!((Node)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual Node has parent but does not have.", new Object[0]);
        }
        return this;
    }

    public NodeAssert doesNotHaveParent() {
        this.isNotNull();
        if (((Node)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual Node does not have parent but has.", new Object[0]);
        }
        return this;
    }

    public NodeAssert hasParentName(String parentName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parentName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualParentName = ((Node)this.actual).getParentName();
        if (!Objects.deepEquals(actualParentName, parentName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parentName, actualParentName});
        }
        return this;
    }

    public NodeAssert isRoot() {
        this.isNotNull();
        if (!((Node)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual Node is root but is not.", new Object[0]);
        }
        return this;
    }

    public NodeAssert isNotRoot() {
        this.isNotNull();
        if (((Node)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual Node is not root but is.", new Object[0]);
        }
        return this;
    }

    public NodeAssert hasSourceFolders(String ... sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getSourceFolders(), (Object[])sourceFolders);
        return this;
    }

    public NodeAssert hasSourceFolders(Collection<? extends String> sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getSourceFolders(), sourceFolders.toArray());
        return this;
    }

    public NodeAssert hasOnlySourceFolders(String ... sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getSourceFolders(), (Object[])sourceFolders);
        return this;
    }

    public NodeAssert hasOnlySourceFolders(Collection<? extends String> sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getSourceFolders(), sourceFolders.toArray());
        return this;
    }

    public NodeAssert doesNotHaveSourceFolders(String ... sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getSourceFolders(), (Object[])sourceFolders);
        return this;
    }

    public NodeAssert doesNotHaveSourceFolders(Collection<? extends String> sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getSourceFolders(), sourceFolders.toArray());
        return this;
    }

    public NodeAssert hasNoSourceFolders() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have sourceFolders but had :\n  <%s>";
        if (((Node)this.actual).getSourceFolders().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Node)this.actual).getSourceFolders()});
        }
        return this;
    }

    public NodeAssert hasValueMetrics(Metric ... valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValueMetrics(), (Object[])valueMetrics);
        return this;
    }

    public NodeAssert hasValueMetrics(Collection<? extends Metric> valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValueMetrics(), valueMetrics.toArray());
        return this;
    }

    public NodeAssert hasOnlyValueMetrics(Metric ... valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValueMetrics(), (Object[])valueMetrics);
        return this;
    }

    public NodeAssert hasOnlyValueMetrics(Collection<? extends Metric> valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValueMetrics(), valueMetrics.toArray());
        return this;
    }

    public NodeAssert doesNotHaveValueMetrics(Metric ... valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValueMetrics(), (Object[])valueMetrics);
        return this;
    }

    public NodeAssert doesNotHaveValueMetrics(Collection<? extends Metric> valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValueMetrics(), valueMetrics.toArray());
        return this;
    }

    public NodeAssert hasNoValueMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have valueMetrics but had :\n  <%s>";
        if (((Node)this.actual).getValueMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Node)this.actual).getValueMetrics()});
        }
        return this;
    }

    public NodeAssert hasValues(Value ... values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValues(), (Object[])values);
        return this;
    }

    public NodeAssert hasValues(Collection<? extends Value> values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValues(), values.toArray());
        return this;
    }

    public NodeAssert hasOnlyValues(Value ... values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValues(), (Object[])values);
        return this;
    }

    public NodeAssert hasOnlyValues(Collection<? extends Value> values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValues(), values.toArray());
        return this;
    }

    public NodeAssert doesNotHaveValues(Value ... values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValues(), (Object[])values);
        return this;
    }

    public NodeAssert doesNotHaveValues(Collection<? extends Value> values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((Node)this.actual).getValues(), values.toArray());
        return this;
    }

    public NodeAssert hasNoValues() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have values but had :\n  <%s>";
        if (((Node)this.actual).getValues().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Node)this.actual).getValues()});
        }
        return this;
    }
}

