/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.jenkins.coverage.model;

import com.parasoft.findings.jenkins.coverage.model.FileNode;
import com.parasoft.findings.jenkins.coverage.model.MethodNode;
import com.parasoft.findings.jenkins.coverage.model.Metric;
import com.parasoft.findings.jenkins.coverage.model.ModuleNode;
import com.parasoft.findings.jenkins.coverage.model.Node;
import com.parasoft.findings.jenkins.coverage.model.Value;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class ModuleNodeAssert
extends AbstractObjectAssert<ModuleNodeAssert, ModuleNode> {
    public ModuleNodeAssert(ModuleNode actual) {
        super((Object)actual, ModuleNodeAssert.class);
    }

    @CheckReturnValue
    public static ModuleNodeAssert assertThat(ModuleNode actual) {
        return new ModuleNodeAssert(actual);
    }

    public ModuleNodeAssert hasAllFileNodes(FileNode ... allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllFileNodes(), (Object[])allFileNodes);
        return this;
    }

    public ModuleNodeAssert hasAllFileNodes(Collection<? extends FileNode> allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllFileNodes(), allFileNodes.toArray());
        return this;
    }

    public ModuleNodeAssert hasOnlyAllFileNodes(FileNode ... allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllFileNodes(), (Object[])allFileNodes);
        return this;
    }

    public ModuleNodeAssert hasOnlyAllFileNodes(Collection<? extends FileNode> allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllFileNodes(), allFileNodes.toArray());
        return this;
    }

    public ModuleNodeAssert doesNotHaveAllFileNodes(FileNode ... allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllFileNodes(), (Object[])allFileNodes);
        return this;
    }

    public ModuleNodeAssert doesNotHaveAllFileNodes(Collection<? extends FileNode> allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllFileNodes(), allFileNodes.toArray());
        return this;
    }

    public ModuleNodeAssert hasNoAllFileNodes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allFileNodes but had :\n  <%s>";
        if (((ModuleNode)this.actual).getAllFileNodes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ModuleNode)this.actual).getAllFileNodes()});
        }
        return this;
    }

    public ModuleNodeAssert hasAllMethodNodes(MethodNode ... allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllMethodNodes(), (Object[])allMethodNodes);
        return this;
    }

    public ModuleNodeAssert hasAllMethodNodes(Collection<? extends MethodNode> allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllMethodNodes(), allMethodNodes.toArray());
        return this;
    }

    public ModuleNodeAssert hasOnlyAllMethodNodes(MethodNode ... allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllMethodNodes(), (Object[])allMethodNodes);
        return this;
    }

    public ModuleNodeAssert hasOnlyAllMethodNodes(Collection<? extends MethodNode> allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllMethodNodes(), allMethodNodes.toArray());
        return this;
    }

    public ModuleNodeAssert doesNotHaveAllMethodNodes(MethodNode ... allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllMethodNodes(), (Object[])allMethodNodes);
        return this;
    }

    public ModuleNodeAssert doesNotHaveAllMethodNodes(Collection<? extends MethodNode> allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getAllMethodNodes(), allMethodNodes.toArray());
        return this;
    }

    public ModuleNodeAssert hasNoAllMethodNodes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allMethodNodes but had :\n  <%s>";
        if (((ModuleNode)this.actual).getAllMethodNodes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ModuleNode)this.actual).getAllMethodNodes()});
        }
        return this;
    }

    public ModuleNodeAssert hasChildren(Node ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public ModuleNodeAssert hasChildren(Collection<? extends Node> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public ModuleNodeAssert hasOnlyChildren(Node ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public ModuleNodeAssert hasOnlyChildren(Collection<? extends Node> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public ModuleNodeAssert doesNotHaveChildren(Node ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public ModuleNodeAssert doesNotHaveChildren(Collection<? extends Node> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public ModuleNodeAssert hasNoChildren() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have children but had :\n  <%s>";
        if (((ModuleNode)this.actual).getChildren().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ModuleNode)this.actual).getChildren()});
        }
        return this;
    }

    public ModuleNodeAssert hasChildren() {
        this.isNotNull();
        if (!((ModuleNode)this.actual).hasChildren()) {
            this.failWithMessage("\nExpecting that actual ModuleNode has children but does not have.", new Object[0]);
        }
        return this;
    }

    public ModuleNodeAssert doesNotHaveChildren() {
        this.isNotNull();
        if (((ModuleNode)this.actual).hasChildren()) {
            this.failWithMessage("\nExpecting that actual ModuleNode does not have children but has.", new Object[0]);
        }
        return this;
    }

    public ModuleNodeAssert isEmpty() {
        this.isNotNull();
        if (!((ModuleNode)this.actual).isEmpty()) {
            this.failWithMessage("\nExpecting that actual ModuleNode is empty but is not.", new Object[0]);
        }
        return this;
    }

    public ModuleNodeAssert isNotEmpty() {
        this.isNotNull();
        if (((ModuleNode)this.actual).isEmpty()) {
            this.failWithMessage("\nExpecting that actual ModuleNode is not empty but is.", new Object[0]);
        }
        return this;
    }

    public ModuleNodeAssert hasFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public ModuleNodeAssert hasFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getFiles(), files.toArray());
        return this;
    }

    public ModuleNodeAssert hasOnlyFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public ModuleNodeAssert hasOnlyFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getFiles(), files.toArray());
        return this;
    }

    public ModuleNodeAssert doesNotHaveFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public ModuleNodeAssert doesNotHaveFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getFiles(), files.toArray());
        return this;
    }

    public ModuleNodeAssert hasNoFiles() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have files but had :\n  <%s>";
        if (((ModuleNode)this.actual).getFiles().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ModuleNode)this.actual).getFiles()});
        }
        return this;
    }

    public ModuleNodeAssert hasMetric(Metric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Metric actualMetric = ((ModuleNode)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }

    public ModuleNodeAssert hasMetrics(Metric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public ModuleNodeAssert hasMetrics(Collection<? extends Metric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public ModuleNodeAssert hasOnlyMetrics(Metric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public ModuleNodeAssert hasOnlyMetrics(Collection<? extends Metric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public ModuleNodeAssert doesNotHaveMetrics(Metric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public ModuleNodeAssert doesNotHaveMetrics(Collection<? extends Metric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public ModuleNodeAssert hasNoMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have metrics but had :\n  <%s>";
        if (((ModuleNode)this.actual).getMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ModuleNode)this.actual).getMetrics()});
        }
        return this;
    }

    public ModuleNodeAssert hasModifiedLines() {
        this.isNotNull();
        if (!((ModuleNode)this.actual).hasModifiedLines()) {
            this.failWithMessage("\nExpecting that actual ModuleNode has modified lines but does not have.", new Object[0]);
        }
        return this;
    }

    public ModuleNodeAssert doesNotHaveModifiedLines() {
        this.isNotNull();
        if (((ModuleNode)this.actual).hasModifiedLines()) {
            this.failWithMessage("\nExpecting that actual ModuleNode does not have modified lines but has.", new Object[0]);
        }
        return this;
    }

    public ModuleNodeAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((ModuleNode)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public ModuleNodeAssert hasParasoftToolName(String parasoftToolName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parasoftToolName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualParasoftToolName = ((ModuleNode)this.actual).getParasoftToolName();
        if (!Objects.deepEquals(actualParasoftToolName, parasoftToolName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parasoftToolName, actualParasoftToolName});
        }
        return this;
    }

    public ModuleNodeAssert hasParent(Node parent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Node actualParent = ((ModuleNode)this.actual).getParent();
        if (!Objects.deepEquals(actualParent, parent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parent, actualParent});
        }
        return this;
    }

    public ModuleNodeAssert hasParent() {
        this.isNotNull();
        if (!((ModuleNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual ModuleNode has parent but does not have.", new Object[0]);
        }
        return this;
    }

    public ModuleNodeAssert doesNotHaveParent() {
        this.isNotNull();
        if (((ModuleNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual ModuleNode does not have parent but has.", new Object[0]);
        }
        return this;
    }

    public ModuleNodeAssert hasParentName(String parentName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parentName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualParentName = ((ModuleNode)this.actual).getParentName();
        if (!Objects.deepEquals(actualParentName, parentName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parentName, actualParentName});
        }
        return this;
    }

    public ModuleNodeAssert isRoot() {
        this.isNotNull();
        if (!((ModuleNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual ModuleNode is root but is not.", new Object[0]);
        }
        return this;
    }

    public ModuleNodeAssert isNotRoot() {
        this.isNotNull();
        if (((ModuleNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual ModuleNode is not root but is.", new Object[0]);
        }
        return this;
    }

    public ModuleNodeAssert hasSourceFolders(String ... sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getSourceFolders(), (Object[])sourceFolders);
        return this;
    }

    public ModuleNodeAssert hasSourceFolders(Collection<? extends String> sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getSourceFolders(), sourceFolders.toArray());
        return this;
    }

    public ModuleNodeAssert hasOnlySourceFolders(String ... sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getSourceFolders(), (Object[])sourceFolders);
        return this;
    }

    public ModuleNodeAssert hasOnlySourceFolders(Collection<? extends String> sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getSourceFolders(), sourceFolders.toArray());
        return this;
    }

    public ModuleNodeAssert doesNotHaveSourceFolders(String ... sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getSourceFolders(), (Object[])sourceFolders);
        return this;
    }

    public ModuleNodeAssert doesNotHaveSourceFolders(Collection<? extends String> sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getSourceFolders(), sourceFolders.toArray());
        return this;
    }

    public ModuleNodeAssert hasNoSourceFolders() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have sourceFolders but had :\n  <%s>";
        if (((ModuleNode)this.actual).getSourceFolders().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ModuleNode)this.actual).getSourceFolders()});
        }
        return this;
    }

    public ModuleNodeAssert hasValueMetrics(Metric ... valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValueMetrics(), (Object[])valueMetrics);
        return this;
    }

    public ModuleNodeAssert hasValueMetrics(Collection<? extends Metric> valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValueMetrics(), valueMetrics.toArray());
        return this;
    }

    public ModuleNodeAssert hasOnlyValueMetrics(Metric ... valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValueMetrics(), (Object[])valueMetrics);
        return this;
    }

    public ModuleNodeAssert hasOnlyValueMetrics(Collection<? extends Metric> valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValueMetrics(), valueMetrics.toArray());
        return this;
    }

    public ModuleNodeAssert doesNotHaveValueMetrics(Metric ... valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValueMetrics(), (Object[])valueMetrics);
        return this;
    }

    public ModuleNodeAssert doesNotHaveValueMetrics(Collection<? extends Metric> valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValueMetrics(), valueMetrics.toArray());
        return this;
    }

    public ModuleNodeAssert hasNoValueMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have valueMetrics but had :\n  <%s>";
        if (((ModuleNode)this.actual).getValueMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ModuleNode)this.actual).getValueMetrics()});
        }
        return this;
    }

    public ModuleNodeAssert hasValues(Value ... values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValues(), (Object[])values);
        return this;
    }

    public ModuleNodeAssert hasValues(Collection<? extends Value> values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValues(), values.toArray());
        return this;
    }

    public ModuleNodeAssert hasOnlyValues(Value ... values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValues(), (Object[])values);
        return this;
    }

    public ModuleNodeAssert hasOnlyValues(Collection<? extends Value> values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValues(), values.toArray());
        return this;
    }

    public ModuleNodeAssert doesNotHaveValues(Value ... values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValues(), (Object[])values);
        return this;
    }

    public ModuleNodeAssert doesNotHaveValues(Collection<? extends Value> values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ModuleNode)this.actual).getValues(), values.toArray());
        return this;
    }

    public ModuleNodeAssert hasNoValues() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have values but had :\n  <%s>";
        if (((ModuleNode)this.actual).getValues().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ModuleNode)this.actual).getValues()});
        }
        return this;
    }
}

