/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.jenkins.coverage.model;

import com.parasoft.findings.jenkins.coverage.model.IntegerValue;
import com.parasoft.findings.jenkins.coverage.model.Metric;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;

public class IntegerValueAssert
extends AbstractObjectAssert<IntegerValueAssert, IntegerValue> {
    public IntegerValueAssert(IntegerValue actual) {
        super((Object)actual, IntegerValueAssert.class);
    }

    @CheckReturnValue
    public static IntegerValueAssert assertThat(IntegerValue actual) {
        return new IntegerValueAssert(actual);
    }

    public IntegerValueAssert hasMetric(Metric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Metric actualMetric = ((IntegerValue)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }

    public IntegerValueAssert hasValue(int value) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualValue = ((IntegerValue)this.actual).getValue();
        if (actualValue != value) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, value, actualValue});
        }
        return this;
    }
}

