/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.jenkins.coverage.model;

import com.parasoft.findings.jenkins.coverage.model.FractionValue;
import com.parasoft.findings.jenkins.coverage.model.Metric;
import java.util.Objects;
import org.apache.commons.lang3.math.Fraction;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;

public class FractionValueAssert
extends AbstractObjectAssert<FractionValueAssert, FractionValue> {
    public FractionValueAssert(FractionValue actual) {
        super((Object)actual, FractionValueAssert.class);
    }

    @CheckReturnValue
    public static FractionValueAssert assertThat(FractionValue actual) {
        return new FractionValueAssert(actual);
    }

    public FractionValueAssert hasFraction(Fraction fraction) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fraction of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Fraction actualFraction = ((FractionValue)this.actual).getFraction();
        if (!Objects.deepEquals(actualFraction, fraction)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fraction, actualFraction});
        }
        return this;
    }

    public FractionValueAssert hasMetric(Metric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Metric actualMetric = ((FractionValue)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }
}

