/*
 * Decompiled with CFR 0.152.
 */
package com.mtvi.plateng.hudson.ldap;

import hudson.util.Secret;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Configuration {
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private String baseDN;
    private String bindDN;
    private Secret bindPassword;
    private String emailAttribute;
    private String initialContextFactoryName;
    private boolean performSearch = false;
    private String searchAttribute;
    private String server;

    public String getBaseDN() {
        return this.baseDN;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public String getBindPassword() {
        return Secret.toString((Secret)this.bindPassword);
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public String getInitialContextFactoryName() {
        return this.initialContextFactoryName != null ? this.initialContextFactoryName : DEFAULT_INITIAL_CONTEXT_FACTORY;
    }

    public String getSearchAttribute() {
        return this.searchAttribute;
    }

    public String getServer() {
        return this.server;
    }

    public boolean isBindCredentialsProvided() {
        return this.bindDN != null && this.bindPassword != null;
    }

    public boolean isPerformSearch() {
        return this.performSearch;
    }

    public boolean isValid() {
        return this.server != null && this.baseDN != null && this.searchAttribute != null && this.emailAttribute != null;
    }

    public String makeUserDN(String userName) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getSearchAttribute()).append("=").append(userName);
        builder.append(",").append(this.getBaseDN());
        return builder.toString();
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    public void setBindPassword(String bindPassword) {
        this.bindPassword = Secret.fromString((String)bindPassword);
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    public void setInitialContextFactoryName(String initialContextFactoryName) {
        this.initialContextFactoryName = initialContextFactoryName;
    }

    public void setPerformSearch(boolean performSearch) {
        this.performSearch = performSearch;
    }

    public void setSearchAttribute(String searchAttribute) {
        this.searchAttribute = searchAttribute;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("baseDN", (Object)this.baseDN).append("bindDN", (Object)this.bindDN).append("bindPassword", (Object)(this.bindPassword != null ? "xxxx" : null)).append("emailAttribute", (Object)this.emailAttribute).append("initialContextFactoryName", (Object)this.initialContextFactoryName).append("performSearch", this.performSearch).append("server", (Object)this.server).toString();
    }
}

