/*
 * Decompiled with CFR 0.152.
 */
package com.mtvi.plateng.hudson.ldap;

import com.mtvi.plateng.hudson.ldap.Configuration;
import com.mtvi.plateng.hudson.ldap.LdapMailAddressResolver;
import hudson.Plugin;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Hudson;
import hudson.tasks.MailAddressResolver;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class PluginImpl
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger("hudson." + PluginImpl.class.getName());
    public Configuration config;

    public void start() throws Exception {
        this.config = this.loadConfiguration();
        MailAddressResolver.all().add((Object)new LdapMailAddressResolver(this.config));
    }

    protected Configuration loadConfiguration() throws IOException {
        XmlFile xmlFile = this.getConfigXml();
        Configuration config = null;
        if (xmlFile.exists()) {
            config = (Configuration)xmlFile.read();
            LOGGER.info(String.format("Loaded configuration data: %s", config.toString()));
        } else {
            LOGGER.info("Could not find configuration file, creating empty object");
            config = new Configuration();
        }
        return config;
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException {
        this.config.setServer(Util.fixEmptyAndTrim((String)formData.optString("server")));
        this.config.setBaseDN(Util.fixEmptyAndTrim((String)formData.optString("baseDN")));
        this.config.setBindDN(Util.fixEmptyAndTrim((String)formData.optString("bindDN")));
        this.config.setBindPassword(Util.fixEmptyAndTrim((String)formData.optString("bindPassword")));
        this.config.setEmailAttribute(Util.fixEmptyAndTrim((String)formData.optString("emailAttribute")));
        this.config.setSearchAttribute(Util.fixEmptyAndTrim((String)formData.optString("searchAttribute")));
        this.config.setPerformSearch(formData.optBoolean("performSearch", false));
        this.getConfigXml().write((Object)this.config);
    }

    protected XmlFile getConfigXml() {
        return new XmlFile(Hudson.XSTREAM, new File(Hudson.getInstance().getRootDir(), LdapMailAddressResolver.class.getName() + ".xml"));
    }
}

