/*
 * Decompiled with CFR 0.152.
 */
package com.mtvi.plateng.hudson.ldap;

import com.mtvi.plateng.hudson.ldap.Configuration;
import hudson.model.User;
import hudson.tasks.MailAddressResolver;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapMailAddressResolver
extends MailAddressResolver {
    private static final Logger LOGGER = Logger.getLogger("hudson." + LdapMailAddressResolver.class.getName());
    private Configuration configuration;

    public LdapMailAddressResolver(Configuration config) {
        this.configuration = config;
        if (!this.configuration.isValid()) {
            LOGGER.warning("Provided configuration isn't valid. Check for missing elements.");
        }
    }

    public String findMailAddressFor(User user) {
        return this.findMailAddressFor(user.getDisplayName());
    }

    protected String findMailAddressFor(String userName) {
        if (this.configuration.isValid()) {
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", this.configuration.getInitialContextFactoryName());
                env.put("java.naming.provider.url", this.configuration.getServer());
                if (this.configuration.isBindCredentialsProvided()) {
                    LOGGER.log(Level.INFO, "Using provided credentials for binding to LDAP server");
                    env.put("java.naming.security.principal", this.configuration.getBindDN());
                    env.put("java.naming.security.credentials", this.configuration.getBindPassword());
                }
                InitialDirContext ctx = new InitialDirContext(env);
                if (this.configuration.isPerformSearch()) {
                    return this.performSearch((DirContext)ctx, userName);
                }
                return this.performLookup((DirContext)ctx, userName);
            }
            catch (NamingException e) {
                LOGGER.log(Level.SEVERE, "Unable to run LDAP query", e);
            }
        }
        return null;
    }

    private String performLookup(DirContext ctx, String userName) throws NamingException {
        String emailAddress = null;
        String dn = this.configuration.makeUserDN(userName);
        LOGGER.log(Level.INFO, String.format("Looking up attributes for DN %s", dn));
        Attributes attrs = ctx.getAttributes(dn, new String[]{this.configuration.getEmailAttribute()});
        Attribute attr = attrs.get(this.configuration.getEmailAttribute());
        if (attr != null) {
            emailAddress = (String)attr.get();
            LOGGER.log(Level.INFO, String.format("Found mail attribute %s for userName %s", emailAddress, userName));
        } else {
            LOGGER.log(Level.INFO, String.format("No mail attribute found for userName %s", userName));
        }
        return emailAddress;
    }

    private String performSearch(DirContext ctx, String userName) throws NamingException {
        String emailAddress = null;
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        String filter = String.format("%s=%s", this.configuration.getSearchAttribute(), userName);
        LOGGER.log(Level.INFO, String.format("Performing LDAP search within %s using %s", this.configuration.getBaseDN(), filter));
        NamingEnumeration<SearchResult> results = ctx.search(this.configuration.getBaseDN(), filter, controls);
        if (results.hasMore()) {
            SearchResult result = results.next();
            Attribute attr = result.getAttributes().get(this.configuration.getEmailAttribute());
            if (attr != null) {
                emailAddress = (String)attr.get();
                LOGGER.log(Level.INFO, String.format("Found mail attribute %s for userName %s", emailAddress, userName));
            } else {
                LOGGER.log(Level.INFO, String.format("No mail attribute found for userName %s", userName));
            }
        } else {
            LOGGER.log(Level.INFO, String.format("No results found for filter %s inside baseDN %s", filter, this.configuration.getBaseDN()));
        }
        return emailAddress;
    }
}

