/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.mabl.integration.jenkins.MablRestApiClient;
import com.mabl.integration.jenkins.MablRestApiClientImpl;
import com.mabl.integration.jenkins.MablStepDeploymentRunner;
import com.mabl.integration.jenkins.MablSystemException;
import com.mabl.integration.jenkins.domain.GetApiKeyResult;
import com.mabl.integration.jenkins.domain.GetApplicationsResult;
import com.mabl.integration.jenkins.domain.GetEnvironmentsResult;
import com.mabl.integration.jenkins.validation.MablStepBuilderValidator;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class MablStepBuilder
extends Builder
implements SimpleBuildStep {
    private final String restApiKeyId;
    private final String environmentId;
    private final String applicationId;
    private String labels;
    private String mablBranch;
    private boolean continueOnPlanFailure;
    private boolean continueOnMablError;
    private boolean disableSslVerification;
    private String apiBaseUrl;
    private String appBaseUrl;
    private String webUrlOverride;
    private String apiUrlOverride;

    public String toString() {
        return "MABL Step Builder " + ((Object)((Object)this)).hashCode();
    }

    @DataBoundConstructor
    public MablStepBuilder(String restApiKeyId, String environmentId, String applicationId) {
        this.restApiKeyId = restApiKeyId;
        this.environmentId = StringUtils.trimToNull((String)environmentId);
        this.applicationId = StringUtils.trimToNull((String)applicationId);
    }

    @DataBoundSetter
    public void setLabels(String labels) {
        String value = labels;
        if (!StringUtils.isEmpty((String)labels)) {
            value = labels.trim().replaceAll(",[\\s]+", ",");
        }
        this.labels = value;
    }

    @DataBoundSetter
    public void setMablBranch(String mablBranch) {
        this.mablBranch = mablBranch;
    }

    @DataBoundSetter
    public void setContinueOnPlanFailure(boolean continueOnPlanFailure) {
        this.continueOnPlanFailure = continueOnPlanFailure;
    }

    @DataBoundSetter
    public void setContinueOnMablError(boolean continueOnMablError) {
        this.continueOnMablError = continueOnMablError;
    }

    @DataBoundSetter
    public void setDisableSslVerification(boolean disableSslVerification) {
        this.disableSslVerification = disableSslVerification;
    }

    @DataBoundSetter
    public void setApiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
    }

    @DataBoundSetter
    public void setAppBaseUrl(String appBaseUrl) {
        this.appBaseUrl = appBaseUrl;
    }

    @DataBoundSetter
    public void setWebUrlOverride(String webUrlOverride) {
        this.webUrlOverride = webUrlOverride;
    }

    @DataBoundSetter
    public void setApiUrlOverride(String apiUrlOverride) {
        this.apiUrlOverride = apiUrlOverride;
    }

    public String getRestApiKeyId() {
        return this.restApiKeyId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getMablBranch() {
        return this.mablBranch;
    }

    public boolean isCollectVars() {
        return this.getDescriptor().isCollectVars();
    }

    public boolean isContinueOnPlanFailure() {
        return this.continueOnPlanFailure;
    }

    public boolean isContinueOnMablError() {
        return this.continueOnMablError;
    }

    public boolean isDisableSslVerification() {
        return this.disableSslVerification;
    }

    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public String getAppBaseUrl() {
        return this.appBaseUrl;
    }

    public String getWebUrlOverride() {
        return this.webUrlOverride;
    }

    public String getApiUrlOverride() {
        return this.apiUrlOverride;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException {
        PrintStream outputStream = listener.getLogger();
        StringCredentials credentials = (StringCredentials)CredentialsProvider.findCredentialById((String)this.restApiKeyId, StringCredentials.class, run, Collections.emptyList());
        if (credentials == null) {
            throw new IllegalStateException("No credentials found for API key provided");
        }
        MablRestApiClientImpl client = new MablRestApiClientImpl("https://api.mabl.com", credentials.getSecret(), "https://app.mabl.com", this.disableSslVerification);
        MablStepDeploymentRunner runner = new MablStepDeploymentRunner(client, outputStream, 10000L, this.environmentId, this.applicationId, this.labels, this.mablBranch, this.continueOnPlanFailure, this.continueOnMablError, this.isCollectVars(), this.getOutputFileLocation(workspace), this.getEnvironmentVars(run, listener), this.webUrlOverride, this.apiUrlOverride);
        Executor executor = Executor.currentExecutor();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Boolean> runnerFuture = executorService.submit(runner);
        try {
            if (runnerFuture.get(21600L, TimeUnit.SECONDS).booleanValue()) {
                run.setResult(Result.SUCCESS);
            } else {
                run.setResult(Result.FAILURE);
                if (executor != null) {
                    executor.interrupt(Result.FAILURE);
                }
            }
        }
        catch (ExecutionException e) {
            outputStream.println("There was an execution error trying to run your tests in mabl");
            e.printStackTrace(outputStream);
            if (this.continueOnMablError) {
                run.setResult(Result.FAILURE);
            } else {
                run.setResult(Result.SUCCESS);
            }
        }
        catch (TimeoutException e) {
            outputStream.printf("Your tests exceeded the maximum plugin runtime limit of %d seconds.%nWe've aborted this Jenkins step, but your tests may still be running in mabl.", 21600);
            if (this.continueOnMablError) {
                run.setResult(Result.FAILURE);
            }
            run.setResult(Result.SUCCESS);
        }
    }

    public MablStepDescriptor getDescriptor() {
        return (MablStepDescriptor)super.getDescriptor();
    }

    private FilePath getOutputFileLocation(FilePath workspace) {
        if (workspace == null) {
            return new FilePath(new File("report.xml"));
        }
        workspace = workspace.isRemote() ? new FilePath(workspace.getChannel(), String.valueOf(workspace) + File.separator + "report.xml") : new FilePath(new File(String.valueOf(workspace) + File.separator + "report.xml"));
        return workspace;
    }

    private EnvVars getEnvironmentVars(Run<?, ?> build, TaskListener listener) {
        PrintStream outputStream = listener.getLogger();
        EnvVars environmentVars = new EnvVars();
        try {
            environmentVars = build.getEnvironment(listener);
        }
        catch (IOException e) {
            outputStream.println("There was an error trying to read environment variables.");
            e.printStackTrace(outputStream);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            outputStream.println("There was an interruption while reading environment variables.");
            e.printStackTrace(outputStream);
        }
        return environmentVars;
    }

    @Nonnull
    public static MablRestApiClient createMablRestApiClient(String restApiKeyId, boolean disableSslVerification, Job job) {
        StringCredentials credentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)job, (Authentication)(job instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)job)) : ACL.SYSTEM), Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)restApiKeyId));
        if (credentials == null) {
            throw new IllegalStateException("No credentials found for API key provided");
        }
        return new MablRestApiClientImpl("https://api.mabl.com", credentials.getSecret(), "https://app.mabl.com", disableSslVerification);
    }

    @Extension
    @Symbol(value={"mabl"})
    public static class MablStepDescriptor
    extends BuildStepDescriptor<Builder> {
        private static final Logger LOGGER = Logger.getLogger(MablStepDescriptor.class.getName());
        private boolean collectVars;

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject json = formData.getJSONObject("mabl");
            this.collectVars = json.getBoolean("collectVars");
            this.save();
            return super.configure(req, formData);
        }

        public boolean isCollectVars() {
            return this.collectVars;
        }

        public boolean isApplicable(Class<? extends AbstractProject> clazz) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return "Run mabl tests";
        }

        @POST
        public FormValidation doValidateForm(@QueryParameter(value="restApiKeyId") String restApiKeyId, @QueryParameter(value="environmentId") String environmentId, @QueryParameter(value="applicationId") String applicationId, @QueryParameter(value="disableSslVerification") boolean disableSslVerification, @AncestorInPath Job job) {
            if (job == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                job.checkPermission(Item.CONFIGURE);
            }
            return MablStepBuilderValidator.validateForm(restApiKeyId, environmentId, applicationId, disableSslVerification, job);
        }

        public ListBoxModel doFillRestApiKeyIdItems(@AncestorInPath Item item, @QueryParameter String restApiKeyId) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(restApiKeyId);
            }
            return result.includeEmptyValue().includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
        }

        public FormValidation doCheckRestApiKeyIds(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    return FormValidation.ok();
                }
            } else if (!item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.warning((String)"Insufficient permissions");
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)"Provide a credentials ID");
            }
            if (value.startsWith("${") && value.endsWith("}")) {
                return FormValidation.warning((String)"Cannot validate expression based credentials");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillApplicationIdItems(@QueryParameter String restApiKeyId, @QueryParameter boolean disableSslVerification, @AncestorInPath Item item) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            if (StringUtils.isBlank((String)restApiKeyId)) {
                return MablStepDescriptor.getSelectValidApiKeyListBoxModel();
            }
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            StringCredentials credentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM), Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)restApiKeyId));
            if (credentials == null) {
                throw new IllegalStateException("No credentials found for API key provided");
            }
            MablRestApiClient client = MablStepDescriptor.createMablRestApiClient(credentials.getSecret(), disableSslVerification);
            return this.getApplicationIdItems(client);
        }

        private ListBoxModel getApplicationIdItems(MablRestApiClient client) {
            try {
                GetApiKeyResult apiKeyResult = client.getApiKeyResult();
                if (apiKeyResult == null) {
                    return MablStepDescriptor.getSelectValidApiKeyListBoxModel();
                }
                ListBoxModel items = new ListBoxModel();
                String organizationId = apiKeyResult.organization_id;
                GetApplicationsResult applicationsResult = client.getApplicationsResult(organizationId);
                items.add("- none -", "");
                for (GetApplicationsResult.Application application : applicationsResult.applications) {
                    items.add(application.name, application.id);
                }
                return items;
            }
            catch (MablSystemException | IOException e) {
                LOGGER.warning("Failed to retrieve application IDs: " + e.getLocalizedMessage());
                return MablStepDescriptor.getSelectValidApiKeyListBoxModel();
            }
        }

        @POST
        public ListBoxModel doFillEnvironmentIdItems(@QueryParameter String restApiKeyId, @QueryParameter boolean disableSslVerification, @AncestorInPath Item item) {
            Jenkins.get().checkPermission(Job.CONFIGURE);
            if (StringUtils.isBlank((String)restApiKeyId)) {
                return MablStepDescriptor.getSelectValidApiKeyListBoxModel();
            }
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            StringCredentials credentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM), Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)restApiKeyId));
            if (credentials == null) {
                throw new IllegalStateException("No credentials found for API key provided");
            }
            MablRestApiClient client = MablStepDescriptor.createMablRestApiClient(credentials.getSecret(), disableSslVerification);
            return this.getEnvironmentIdItems(client);
        }

        private ListBoxModel getEnvironmentIdItems(MablRestApiClient client) {
            try {
                GetApiKeyResult apiKeyResult = client.getApiKeyResult();
                if (apiKeyResult == null) {
                    return MablStepDescriptor.getSelectValidApiKeyListBoxModel();
                }
                ListBoxModel items = new ListBoxModel();
                String organizationId = apiKeyResult.organization_id;
                GetEnvironmentsResult environmentsResult = client.getEnvironmentsResult(organizationId);
                items.add("- none -", "");
                for (GetEnvironmentsResult.Environment environment : environmentsResult.environments) {
                    items.add(environment.name, environment.id);
                }
                return items;
            }
            catch (MablSystemException | IOException e) {
                LOGGER.warning("Failed to retrieve environment IDs: " + e.getLocalizedMessage());
                return MablStepDescriptor.getSelectValidApiKeyListBoxModel();
            }
        }

        public FormValidation doCheckMablBranch(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            if (value.matches("[A-Za-z0-9_-]+")) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"The branch name field may only contain alpha-numeric characters, as well as dashes and underscores.");
        }

        private static ListBoxModel getSelectValidApiKeyListBoxModel() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Select a valid API key");
            return listBoxModel;
        }

        private static MablRestApiClient createMablRestApiClient(Secret key, boolean disableSslVerification) {
            return new MablRestApiClientImpl("https://api.mabl.com", key, "https://app.mabl.com", disableSslVerification);
        }
    }
}

