/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.google.common.collect.ImmutableCollection;
import com.mabl.integration.jenkins.MablRestApiClient;
import com.mabl.integration.jenkins.MablStepDeploymentRunner;
import com.mabl.integration.jenkins.MablSystemException;
import com.mabl.integration.jenkins.domain.CreateDeploymentProperties;
import com.mabl.integration.jenkins.domain.CreateDeploymentResult;
import com.mabl.integration.jenkins.domain.ExecutionResult;
import com.mabl.integration.jenkins.test.output.Properties;
import com.mabl.integration.jenkins.test.output.Property;
import com.mabl.integration.jenkins.test.output.TestCase;
import com.mabl.integration.jenkins.test.output.TestSuite;
import hudson.EnvVars;
import hudson.FilePath;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MablStepDeploymentRunnerTest {
    private static final long TEST_TIMEOUT_SECONDS = 2L;
    private static final long TEST_POLLING_INTERVAL_MILLISECONDS = 50L;
    private final String environmentId = "foo-env-e";
    private final String applicationId = "foo-app-a";
    private final String mablBranch = "my-development-branch";
    private final String labels = "foo-label";
    private final String eventId = "foo-event-id";
    private final FilePath buildPath = new FilePath(new File("/dev/null"));
    private final EnvVars envVars = new EnvVars();
    private final String webUrlOverride = "https://test-web-override.example.com";
    private final String apiUrlOverride = "https://test-api-override.example.com";
    private MablStepDeploymentRunner runner;
    private MablRestApiClient client;
    private PrintStream outputStream;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)2L);

    @Before
    public void setup() {
        this.client = (MablRestApiClient)Mockito.mock(MablRestApiClient.class);
        this.outputStream = (PrintStream)Mockito.mock(PrintStream.class);
        this.runner = new MablStepDeploymentRunner(this.client, this.outputStream, 50L, "foo-env-e", "foo-app-a", "foo-label", null, false, false, true, this.buildPath, this.envVars, null, null);
    }

    @Test
    public void runTestsHappyPath() throws IOException {
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenReturn((Object)new CreateDeploymentResult("foo-event-id", "workspace-w"));
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenReturn((Object)this.createExecutionResult("succeeded", true));
        Assert.assertTrue((String)"successful outcome expected", (boolean)this.runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void runTestsHappyPathManyPollings() throws IOException {
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenReturn((Object)new CreateDeploymentResult("foo-event-id", "workspace-w"));
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenReturn((Object)this.createExecutionResult("queued", true)).thenReturn((Object)this.createExecutionResult("pre-execution", true)).thenReturn((Object)this.createExecutionResult("scheduling", true)).thenReturn((Object)this.createExecutionResult("scheduled", true)).thenReturn((Object)this.createExecutionResult("running", true)).thenReturn((Object)this.createExecutionResult("post-execution", true)).thenReturn((Object)this.createExecutionResult("completed", true));
        Assert.assertTrue((String)"successful outcome expected", (boolean)this.runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void runTestsMablErrorOnCreateDeployment() throws IOException {
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenThrow(new Throwable[]{new MablSystemException("mabl error")});
        Assert.assertFalse((String)"failure outcome expected", (boolean)this.runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void runTestsMablErrorDeploymentResultsNotFound() throws IOException {
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenThrow(new Throwable[]{new MablSystemException("mabl error")});
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenReturn(null);
        Assert.assertFalse((String)"failure outcome expected", (boolean)this.runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void runTestsPlanFailure() throws IOException {
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenReturn((Object)new CreateDeploymentResult("foo-event-id", "workspace-w"));
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenReturn((Object)this.createExecutionResult("failed", false));
        Assert.assertFalse((String)"failure outcome expected", (boolean)this.runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void continueOnMablError() throws IOException {
        MablStepDeploymentRunner runner = new MablStepDeploymentRunner(this.client, this.outputStream, 50L, "foo-env-e", "foo-app-a", "foo-label", null, false, true, true, this.buildPath, this.envVars, null, null);
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenThrow(new Throwable[]{new MablSystemException("mabl error")});
        Assert.assertTrue((String)"failure override expected", (boolean)runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void continueOnPlanFailure() throws IOException {
        MablStepDeploymentRunner runner = new MablStepDeploymentRunner(this.client, this.outputStream, 50L, "foo-env-e", "foo-app-a", "foo-label", null, true, false, true, this.buildPath, this.envVars, null, null);
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenReturn((Object)new CreateDeploymentResult("foo-event-id", "workspace-w"));
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenReturn((Object)this.createExecutionResult("queued", true)).thenReturn((Object)this.createExecutionResult("terminated", false));
        Assert.assertTrue((String)"failure override expected", (boolean)runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void planWithRetrySuccess() throws IOException {
        MablStepDeploymentRunner runner = new MablStepDeploymentRunner(this.client, this.outputStream, 50L, "foo-env-e", "foo-app-a", "foo-label", null, false, false, true, this.buildPath, this.envVars, null, null);
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenReturn((Object)new CreateDeploymentResult("foo-event-id", "workspace-w"));
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenReturn((Object)this.createExecutionResultWithRetry(true));
        Assert.assertTrue((String)"success expected on successful retry", (boolean)runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void planWithRetryFailure() throws IOException {
        MablStepDeploymentRunner runner = new MablStepDeploymentRunner(this.client, this.outputStream, 50L, "foo-env-e", "foo-app-a", "foo-label", null, false, false, true, this.buildPath, this.envVars, null, null);
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenReturn((Object)new CreateDeploymentResult("foo-event-id", "workspace-w"));
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenReturn((Object)this.createExecutionResultWithRetry(false));
        Assert.assertFalse((String)"failure expected", (boolean)runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void planWithMablBranch() throws IOException {
        MablStepDeploymentRunner runner = new MablStepDeploymentRunner(this.client, this.outputStream, 50L, "foo-env-e", "foo-app-a", "foo-label", "my-development-branch", false, false, true, this.buildPath, this.envVars, null, null);
        CreateDeploymentResult createDeploymentResult = new CreateDeploymentResult("foo-event-id", "workspace-w");
        createDeploymentResult.setMablBranch("my-development-branch");
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.eq((Object)"my-development-branch"), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenReturn((Object)createDeploymentResult);
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenReturn((Object)this.createExecutionResult("completed", true));
        Assert.assertTrue((String)"successful outcome expected", (boolean)runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void planWithFailedEventCreation() throws IOException {
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenReturn(null);
        Assert.assertFalse((String)"failure expected as continue on error is false", (boolean)this.runner.call());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void executionResultToString_undefinedStatus_isWaiting() {
        ExecutionResult.JourneyExecutionResult result = new ExecutionResult.JourneyExecutionResult(null, null, null, null, null, null, false, Long.valueOf(0L), Long.valueOf(0L), Collections.emptyList());
        Assert.assertEquals((Object)"[waiting]", (Object)MablStepDeploymentRunner.executionResultToString((ExecutionResult.JourneyExecutionResult)result));
    }

    @Test
    public void executionResultToString_failed_showsURL() {
        ExecutionResult.JourneyExecutionResult result = new ExecutionResult.JourneyExecutionResult(null, null, null, "http://appUrl", "failed", null, false, Long.valueOf(0L), Long.valueOf(0L), Collections.emptyList());
        Assert.assertEquals((Object)"[failed] at [http://appUrl]", (Object)MablStepDeploymentRunner.executionResultToString((ExecutionResult.JourneyExecutionResult)result));
    }

    @Test
    public void executionResultToString_completed_showsCompleted() {
        ExecutionResult.JourneyExecutionResult result = new ExecutionResult.JourneyExecutionResult(null, null, null, null, "completed", null, false, Long.valueOf(0L), Long.valueOf(0L), Collections.emptyList());
        Assert.assertEquals((Object)"[completed]", (Object)MablStepDeploymentRunner.executionResultToString((ExecutionResult.JourneyExecutionResult)result));
    }

    @Test
    public void executionSummary_times() {
        ExecutionResult executionResult = this.createExecutionResultWithTimes();
        for (ExecutionResult.ExecutionSummary summary : executionResult.executions) {
            TestSuite suite = this.runner.createTestSuite(summary);
            Assert.assertEquals((long)suite.getTime(), (long)((summary.stopTime - summary.startTime) / 1000L));
            ExecutionResult.JourneyExecutionResult firstTest = (ExecutionResult.JourneyExecutionResult)summary.journeyExecutions.get(0);
            Assert.assertEquals((long)((TestCase)suite.getTestCases().get(0)).getDuration(), (long)((firstTest.stopTime - firstTest.startTime) / 1000L));
        }
    }

    @Test
    public void executionSummary_testCaseIdsAndSkipped() {
        ExecutionResult executionResult = this.createExecutionResultWithTestCaseIds();
        for (ExecutionResult.ExecutionSummary summary : executionResult.executions) {
            TestSuite suite = this.runner.createTestSuite(summary);
            Properties props = suite.getProperties();
            Assert.assertNotNull((Object)props);
            ImmutableCollection propertyCollection = props.getProperties();
            Assert.assertNotNull((Object)propertyCollection);
            boolean foundFailed = false;
            boolean foundCompleted = false;
            boolean foundSkipped = false;
            block19: for (Property property : propertyCollection) {
                switch (property.getName()) {
                    case "failed-test-cases": {
                        Assert.assertEquals((Object)"FAILED-1,FAILED-11,FAILED-91", (Object)property.getValue());
                        foundFailed = true;
                        continue block19;
                    }
                    case "completed-test-cases": {
                        Assert.assertEquals((Object)"COMPLETED-2", (Object)property.getValue());
                        foundCompleted = true;
                        continue block19;
                    }
                    case "skipped-test-cases": {
                        Assert.assertEquals((Object)"SKIPPED-3,SKIPPED-33,SKIPPED-333", (Object)property.getValue());
                        foundSkipped = true;
                        continue block19;
                    }
                }
                Assert.fail();
            }
            Assert.assertTrue((boolean)foundCompleted);
            Assert.assertTrue((boolean)foundFailed);
            Assert.assertTrue((boolean)foundSkipped);
            Assert.assertEquals((long)2L, (long)suite.getFailures());
            Assert.assertEquals((long)1L, (long)suite.getSkipped());
            Assert.assertEquals((long)4L, (long)suite.getTests());
            for (TestCase testCase : suite.getTestCases()) {
                ImmutableCollection casePropertyCollection = testCase.getProperties();
                Assert.assertNotNull((Object)casePropertyCollection);
                Property caseProperty = (Property)casePropertyCollection.iterator().next();
                Assert.assertEquals((Object)"requirement", (Object)caseProperty.getName());
                if (testCase.getFailure() != null) {
                    switch (testCase.getJourney()) {
                        case "Failing Test 1": {
                            Assert.assertEquals((Object)"FAILED-1,FAILED-91", (Object)caseProperty.getValue());
                            break;
                        }
                        case "Failing Test 2": {
                            Assert.assertEquals((Object)"FAILED-11", (Object)caseProperty.getValue());
                            break;
                        }
                        default: {
                            System.err.println("journey:" + testCase.getJourney());
                            Assert.fail();
                        }
                    }
                    Assert.assertNull((Object)testCase.getSkipped());
                    continue;
                }
                if (testCase.getSkipped() != null) {
                    Assert.assertEquals((Object)"SKIPPED-3,SKIPPED-33,SKIPPED-333", (Object)caseProperty.getValue());
                    Assert.assertNull((Object)testCase.getFailure());
                    continue;
                }
                Assert.assertEquals((Object)"COMPLETED-2", (Object)caseProperty.getValue());
                Assert.assertNull((Object)testCase.getSkipped());
                Assert.assertNull((Object)testCase.getFailure());
            }
        }
    }

    @Test
    public void testInterruptedExecution() throws IOException {
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenReturn((Object)new CreateDeploymentResult("foo-event-id", "workspace-w"));
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenAnswer(invocation -> {
            Thread.currentThread().interrupt();
            return this.createExecutionResult("running", true);
        });
        Assert.assertTrue((String)"successful outcome expected due to interruption handling", (boolean)this.runner.call());
        Assert.assertFalse((String)"Thread Interrupted status should be clear", (boolean)Thread.currentThread().isInterrupted());
        ((MablRestApiClient)Mockito.verify((Object)this.client)).close();
    }

    @Test
    public void testSafePlanNameWithNull() throws IOException {
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenReturn((Object)new CreateDeploymentResult("foo-event-id", "workspace-w"));
        ExecutionResult.EventStatus eventStatus = new ExecutionResult.EventStatus();
        eventStatus.setSucceeded(Boolean.valueOf(true));
        ExecutionResult executionResult = new ExecutionResult(Collections.singletonList(new ExecutionResult.ExecutionSummary("completed", "success", true, Long.valueOf(0L), Long.valueOf(0L), new ExecutionResult.PlanSummary("plan-id", null), null, List.of(new ExecutionResult.JourneySummary("journey-id", "Test Journey", "href", "appHref")), List.of(new ExecutionResult.JourneyExecutionResult("journey-id", "execution-id", "href", "appHref", "completed", null, true, Long.valueOf(0L), Long.valueOf(0L), Collections.emptyList())))), eventStatus);
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenReturn((Object)executionResult);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream capturedOutputStream = new PrintStream(byteArrayOutputStream);
        MablStepDeploymentRunner runnerWithCapture = new MablStepDeploymentRunner(this.client, capturedOutputStream, 50L, "foo-env-e", "foo-app-a", "foo-label", null, false, false, true, this.buildPath, this.envVars, null, null);
        Assert.assertTrue((String)"successful outcome expected", (boolean)runnerWithCapture.call());
        String output = byteArrayOutputStream.toString();
        Assert.assertTrue((String)"Output should contain unnamed plan fallback", (boolean)output.contains("<Unnamed Plan>"));
        TestSuite testSuite = runnerWithCapture.createTestSuite((ExecutionResult.ExecutionSummary)executionResult.executions.get(0));
        Assert.assertEquals((Object)"<Unnamed Plan>", (Object)testSuite.getName());
    }

    @Test
    public void testDeploymentCreateWithUrlOverrides() throws IOException {
        MablStepDeploymentRunner runnerWithOverrides = new MablStepDeploymentRunner(this.client, this.outputStream, 50L, "foo-env-e", "foo-app-a", "foo-label", null, false, false, true, this.buildPath, this.envVars, "https://test-web-override.example.com", "https://test-api-override.example.com");
        Mockito.when((Object)this.client.createDeploymentEvent((String)ArgumentMatchers.eq((Object)"foo-env-e"), (String)ArgumentMatchers.eq((Object)"foo-app-a"), (String)ArgumentMatchers.eq((Object)"foo-label"), (String)ArgumentMatchers.isNull(), (CreateDeploymentProperties)ArgumentMatchers.any(CreateDeploymentProperties.class))).thenAnswer(invocation -> {
            CreateDeploymentProperties props = (CreateDeploymentProperties)invocation.getArgument(4);
            Assert.assertNotNull((String)"Properties should not be null", (Object)props);
            Assert.assertNotNull((String)"Plan overrides should not be null", (Object)props.getPlan_overrides());
            Assert.assertEquals((String)"Web URL override should match", (Object)"https://test-web-override.example.com", (Object)props.getPlan_overrides().getWeb_url());
            Assert.assertEquals((String)"API URL override should match", (Object)"https://test-api-override.example.com", (Object)props.getPlan_overrides().getApi_url());
            return new CreateDeploymentResult("foo-event-id", "workspace-w");
        });
        Mockito.when((Object)this.client.getExecutionResults("foo-event-id")).thenReturn((Object)this.createExecutionResult("succeeded", true));
        Assert.assertTrue((String)"successful outcome expected", (boolean)runnerWithOverrides.call());
    }

    @Test
    public void testExecutionSummaryWithTestCaseStatus() {
        ExecutionResult.EventStatus eventStatus = new ExecutionResult.EventStatus();
        eventStatus.setSucceeded(Boolean.valueOf(false));
        ExecutionResult.ExecutionSummary summary = new ExecutionResult.ExecutionSummary("failed", "Some tests failed", false, Long.valueOf(1000L), Long.valueOf(5000L), new ExecutionResult.PlanSummary("plan-id", "Plan name"), null, Arrays.asList(new ExecutionResult.JourneySummary("j1", "Journey Failed", "href1", "appHref1"), new ExecutionResult.JourneySummary("j2", "Journey Skipped", "href2", "appHref2")), Arrays.asList(new ExecutionResult.JourneyExecutionResult("j1", "exec1", "href1", "appHref1", "failed", "Failed due to assertion", false, Long.valueOf(1000L), Long.valueOf(3000L), Arrays.asList(new ExecutionResult.TestCaseID("TEST-123"), new ExecutionResult.TestCaseID("TEST-456"))), new ExecutionResult.JourneyExecutionResult("j2", "exec2", "href2", "appHref2", "skipped", "Skipped due to dependency", false, Long.valueOf(1000L), Long.valueOf(1000L), List.of(new ExecutionResult.TestCaseID("TEST-789")))));
        TestSuite testSuite = this.runner.createTestSuite(summary);
        Assert.assertEquals((long)2L, (long)testSuite.getTests());
        Assert.assertEquals((long)1L, (long)testSuite.getFailures());
        Assert.assertEquals((long)1L, (long)testSuite.getSkipped());
        boolean foundFailedTestCases = false;
        boolean foundSkippedTestCases = false;
        for (Property property : testSuite.getProperties().getProperties()) {
            if (property.getName().equals("failed-test-cases")) {
                Assert.assertEquals((Object)"TEST-123,TEST-456", (Object)property.getValue());
                foundFailedTestCases = true;
                continue;
            }
            if (!property.getName().equals("skipped-test-cases")) continue;
            Assert.assertEquals((Object)"TEST-789", (Object)property.getValue());
            foundSkippedTestCases = true;
        }
        Assert.assertTrue((String)"Failed test cases should be recorded in properties", (boolean)foundFailedTestCases);
        Assert.assertTrue((String)"Skipped test cases should be recorded in properties", (boolean)foundSkippedTestCases);
        for (TestCase testCase : testSuite.getTestCases()) {
            Property requirement;
            if (testCase.getJourney().equals("Journey Failed")) {
                requirement = (Property)testCase.getProperties().iterator().next();
                Assert.assertEquals((Object)"requirement", (Object)requirement.getName());
                Assert.assertEquals((Object)"TEST-123,TEST-456", (Object)requirement.getValue());
                continue;
            }
            if (!testCase.getJourney().equals("Journey Skipped")) continue;
            requirement = (Property)testCase.getProperties().iterator().next();
            Assert.assertEquals((Object)"requirement", (Object)requirement.getName());
            Assert.assertEquals((Object)"TEST-789", (Object)requirement.getValue());
        }
    }

    private ExecutionResult createExecutionResultWithTestCaseIds() {
        ExecutionResult.EventStatus eventStatus = new ExecutionResult.EventStatus();
        eventStatus.setSucceeded(Boolean.valueOf(false));
        eventStatus.setSucceededFirstAttempt(Boolean.valueOf(false));
        return new ExecutionResult(Collections.singletonList(new ExecutionResult.ExecutionSummary("failed", "some tests failed", true, Long.valueOf(1596323475000L), Long.valueOf(1596323575000L), null, null, Arrays.asList(new ExecutionResult.JourneySummary("failingTestId1-j", "Failing Test 1", "https://app.example.com", "https://app.example.com"), new ExecutionResult.JourneySummary("skippedTestId-j", "Skipped Test", "https://app.example.com", "https://app.example.com"), new ExecutionResult.JourneySummary("completedTestId-j", "Completed Test", "https://app.example.com", "https://app.example.com"), new ExecutionResult.JourneySummary("failingTestId2-j", "Failing Test 2", "https://app.example.com", "https://app.example.com")), Arrays.asList(new ExecutionResult.JourneyExecutionResult("failingTestId1-j", "failingTestId1-jr", "http://www.example.com", "http://app.example.com", "failed", "failed because ", false, Long.valueOf(1596323475000L), Long.valueOf(1596323565000L), Arrays.asList(new ExecutionResult.TestCaseID("FAILED-1"), new ExecutionResult.TestCaseID("FAILED-91"))), new ExecutionResult.JourneyExecutionResult("skippedTestId-j", "skippedTestId-jr", "http://www.example.com", "http://app.example.com", "skipped", "skipped because a dependent test failed", false, Long.valueOf(1596323475001L), Long.valueOf(1596323565001L), Arrays.asList(new ExecutionResult.TestCaseID("SKIPPED-3"), new ExecutionResult.TestCaseID("SKIPPED-33"), new ExecutionResult.TestCaseID("SKIPPED-333"))), new ExecutionResult.JourneyExecutionResult("completedTestId-j", "completedTestId-jr", "http://www.example.com", "http://app.example.com", "completed", "success", false, Long.valueOf(1596323475002L), Long.valueOf(1596323565002L), Collections.singletonList(new ExecutionResult.TestCaseID("COMPLETED-2"))), new ExecutionResult.JourneyExecutionResult("failingTestId2-j", "failingTestId2-jr", "http://www.example.com", "http://app.example.com", "failed", "failed because ", false, Long.valueOf(1596323475003L), Long.valueOf(1596323565003L), Collections.singletonList(new ExecutionResult.TestCaseID("FAILED-11")))))), eventStatus);
    }

    private ExecutionResult createExecutionResultWithTimes() {
        ExecutionResult.EventStatus eventStatus = new ExecutionResult.EventStatus();
        eventStatus.setSucceeded(Boolean.valueOf(true));
        eventStatus.setSucceededFirstAttempt(Boolean.valueOf(false));
        return new ExecutionResult(Arrays.asList(new ExecutionResult.ExecutionSummary("failed", "first attempt failed", true, Long.valueOf(1596323475000L), Long.valueOf(1596323575000L), null, null, new ArrayList(), Collections.singletonList(new ExecutionResult.JourneyExecutionResult("firstJourneyRun-jr", "executionId1", "http://www.example.com", "http://app.example.com", "failed", "failed on the first run", false, Long.valueOf(1596323475000L), Long.valueOf(1596323565000L), Collections.emptyList()))), new ExecutionResult.ExecutionSummary("completed", "retry succeeded", true, Long.valueOf(1596323575000L), Long.valueOf(1596323775000L), null, null, new ArrayList(), Collections.singletonList(new ExecutionResult.JourneyExecutionResult("secondJourneyRun-jr", "executionId2", "http://www.example.com", "http://app.example.com", "success", "succeeded", false, Long.valueOf(1596323575000L), Long.valueOf(1596323755000L), Collections.emptyList())))), eventStatus);
    }

    private ExecutionResult createExecutionResult(String status, boolean success) {
        ExecutionResult.EventStatus eventStatus = new ExecutionResult.EventStatus();
        eventStatus.setSucceeded(Boolean.valueOf(success));
        return new ExecutionResult(Collections.singletonList(new ExecutionResult.ExecutionSummary(status, "all is well", success, Long.valueOf(0L), Long.valueOf(0L), new ExecutionResult.PlanSummary("plan-id", "Plan name"), new ExecutionResult.PlanExecutionResult("plan-id", true), new ArrayList(), new ArrayList())), eventStatus);
    }

    private ExecutionResult createExecutionResultWithRetry(boolean success) {
        ExecutionResult.EventStatus eventStatus = new ExecutionResult.EventStatus();
        eventStatus.setSucceeded(Boolean.valueOf(success));
        eventStatus.setSucceededFirstAttempt(Boolean.valueOf(false));
        return new ExecutionResult(Arrays.asList(new ExecutionResult.ExecutionSummary("failed", "first attempt failed", success, Long.valueOf(0L), Long.valueOf(0L), new ExecutionResult.PlanSummary("plan-id", "Plan name"), null, new ArrayList(), new ArrayList()), new ExecutionResult.ExecutionSummary("completed", "retry succeeded", success, Long.valueOf(0L), Long.valueOf(0L), new ExecutionResult.PlanSummary("plan-id", "Plan name"), null, new ArrayList(), new ArrayList())), eventStatus);
    }
}

