/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.settings;

import com.infullmobile.jenkins.plugin.restrictedregister.module.impl.JenkinsDescriptorImpl;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.IPluginConfig;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.ISecurityRealmRegistrationConfig;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.RegistrationConfigCollection;
import com.infullmobile.jenkins.plugin.restrictedregister.settings.RegistrationRulesSet;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.LinkedList;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class PluginGlobalConfig
extends GlobalConfiguration
implements IPluginConfig {
    private static final String NAMESPACE = "restricted-register";
    private static final String JSON_KEY_RULES_LIST = "rulesList";
    private boolean enabled;
    private String adminEmail;
    private List<RegistrationRulesSet> rulesList;
    private String emailFooter;
    private RegistrationConfigCollection registrationConfigurations;
    private String replyToEmail;

    public PluginGlobalConfig() {
        if (this.getConfigFile().exists()) {
            this.load();
        } else {
            this.save();
        }
    }

    @DataBoundSetter
    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @DataBoundSetter
    public void setRulesList(List<RegistrationRulesSet> value) {
        this.getRulesList().clear();
        if (value != null) {
            this.getRulesList().addAll(value);
        }
    }

    @Override
    public List<RegistrationRulesSet> getRulesList() {
        if (this.rulesList == null) {
            this.rulesList = new LinkedList<RegistrationRulesSet>();
        }
        return this.rulesList;
    }

    @Override
    public String getAdminEmail() {
        return this.adminEmail;
    }

    @DataBoundSetter
    public void setAdminEmail(String value) {
        this.adminEmail = value;
    }

    @Override
    public String getReplyToEmail() {
        return this.replyToEmail;
    }

    @DataBoundSetter
    public void setReplyToEmail(String value) {
        this.replyToEmail = value;
    }

    @Override
    public String getEmailFooter() {
        return this.emailFooter;
    }

    @DataBoundSetter
    public void setEmailFooter(String emailFooter) {
        this.emailFooter = emailFooter;
    }

    @Override
    public RegistrationConfigCollection getRegistrationConfigurations() {
        if (this.registrationConfigurations == null) {
            this.registrationConfigurations = new RegistrationConfigCollection();
        }
        return this.registrationConfigurations;
    }

    @DataBoundSetter
    public void setRegistrationConfigurations(RegistrationConfigCollection values) {
        this.getRegistrationConfigurations().clear();
        this.getRegistrationConfigurations().addAll(values);
    }

    public DescriptorExtensionList getRegistrationConfigDescriptors() {
        return JenkinsDescriptorImpl.getJenkinsInstanceOrDie().getDescriptorList(ISecurityRealmRegistrationConfig.class);
    }

    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        JSONObject rootNode = json.getJSONObject(NAMESPACE);
        req.bindJSON((Object)this, rootNode);
        this.applyEmptyRulesListWorkaroundIfNeeded(rootNode);
        this.save();
        return true;
    }

    private void applyEmptyRulesListWorkaroundIfNeeded(JSONObject rootNode) {
        if (!rootNode.has(JSON_KEY_RULES_LIST)) {
            this.setRulesList(null);
        }
    }
}

