/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.form;

import com.infullmobile.jenkins.plugin.restrictedregister.RegistrationException;
import com.infullmobile.jenkins.plugin.restrictedregister.form.BaseFormField;
import com.infullmobile.jenkins.plugin.restrictedregister.form.IFormValidator;
import com.infullmobile.jenkins.plugin.restrictedregister.security.InvalidSecurityRealmException;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.HudsonSecurityRealmRegistration;
import com.infullmobile.jenkins.plugin.restrictedregister.security.hudson.Messages;
import hudson.security.HudsonPrivateSecurityRealm;
import net.sf.json.JSONObject;
import org.acegisecurity.userdetails.UsernameNotFoundException;

public class ExistingUserFormValidator
implements IFormValidator<HudsonSecurityRealmRegistration> {
    @Override
    public void verifyFormData(HudsonSecurityRealmRegistration securityRealmRegistration, JSONObject object) throws RegistrationException, InvalidSecurityRealmException {
        if (this.userExists(securityRealmRegistration, object)) {
            throw new RegistrationException(Messages.RRError_Hudson_UserAlreadyExists());
        }
    }

    private boolean userExists(HudsonSecurityRealmRegistration securityRealmRegistration, JSONObject object) throws InvalidSecurityRealmException {
        String username = (String)BaseFormField.USERNAME.fromJSON(object);
        try {
            ((HudsonPrivateSecurityRealm)securityRealmRegistration.getSecurityRealm()).loadUserByUsername(username);
            return true;
        }
        catch (UsernameNotFoundException e) {
            return false;
        }
    }
}

