/*
 * Decompiled with CFR 0.152.
 */
package com.infullmobile.jenkins.plugin.restrictedregister;

import com.infullmobile.jenkins.plugin.restrictedregister.RegistrationException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.json.JSONObject;

public final class API {
    static final String JSON_KEY_STATUS = "status";
    static final String JSON_KEY_ERROR_DATA_MESSAGE = "message";
    static final String JSON_KEY_DATA = "data";
    static final String JSON_STATUS_ERROR = "error";
    static final String JSON_STATUS_SUCCESS = "success";
    private static final String FORMAT_GENERAL_ERROR = "error (500): %s";
    private static final String GENERAL_ERROR_MESSAGE = String.format(Locale.US, "error (500): %s", "server error");

    private API() {
    }

    public static JSONObject success() {
        return API.success(null);
    }

    public static JSONObject success(@Nullable JSONObject data) {
        JSONObject ret = new JSONObject();
        ret.put(JSON_KEY_STATUS, (Object)JSON_STATUS_SUCCESS);
        if (data != null) {
            ret.put(JSON_KEY_DATA, (Object)data);
        } else {
            ret.put(JSON_KEY_DATA, (Object)new JSONObject());
        }
        return ret;
    }

    public static JSONObject errorWithException(@Nullable Exception exception) {
        if (exception != null && exception instanceof RegistrationException) {
            return API.errorWithData(((RegistrationException)exception).toJson());
        }
        String errorMessage = API.getMessageForError(exception);
        return API.errorWithMessage(errorMessage);
    }

    public static JSONObject errorWithMessage(@Nonnull String errorMessage) {
        JSONObject data = new JSONObject();
        data.put(JSON_KEY_ERROR_DATA_MESSAGE, (Object)errorMessage);
        return API.errorWithData(data);
    }

    private static JSONObject errorWithData(@Nullable JSONObject data) {
        if (data == null) {
            return API.errorWithException(null);
        }
        JSONObject ret = new JSONObject();
        ret.put(JSON_KEY_DATA, (Object)data);
        ret.put(JSON_KEY_STATUS, (Object)JSON_STATUS_ERROR);
        return ret;
    }

    private static String getMessageForError(@Nullable Exception exception) {
        String ret = exception == null ? GENERAL_ERROR_MESSAGE : (exception instanceof RegistrationException ? exception.getMessage() : String.format(Locale.US, FORMAT_GENERAL_ERROR, exception.getMessage()));
        return ret;
    }
}

