/*
 * Decompiled with CFR 0.152.
 */
package com.incapptic.plugins.connect;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class OutputUtils {
    public static final String ERROR = "[Error]  ";
    public static final String INFO = "[Info]   ";
    public static final String SUCCESS = "[Success]";
    private final PrintStream printStream;
    private static Map<Integer, OutputUtils> INSTANCES = new HashMap<Integer, OutputUtils>();

    static OutputUtils getLoggerForStream(PrintStream stream) {
        if (!INSTANCES.containsKey(stream.hashCode())) {
            INSTANCES.put(stream.hashCode(), new OutputUtils(stream));
        }
        return INSTANCES.get(stream.hashCode());
    }

    private OutputUtils(PrintStream printStream) {
        this.printStream = printStream;
    }

    private void print(String prefix, String message) {
        this.printStream.println(String.format("%s %s", prefix, message));
    }

    void info(String message) {
        this.print(INFO, message);
    }

    void error(String message) {
        this.print(ERROR, message);
    }

    void success(String message) {
        this.print(SUCCESS, message);
    }
}

