/*
 * Decompiled with CFR 0.152.
 */
package com.incapptic.plugins.connect;

import com.incapptic.plugins.connect.ArtifactsNotFoundException;
import com.incapptic.plugins.connect.MultipleArtifactsException;
import com.incapptic.plugins.connect.OutputUtils;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ConnectNotifier
extends Recorder
implements Serializable,
SimpleBuildStep {
    public static final String TOKEN_HEADER_NAME = "X-Connect-Token";
    private static final long serialVersionUID = 1L;
    public static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/octet-stream");
    private String token;
    private String url;
    private Integer appId;
    private String mask;

    @DataBoundConstructor
    public ConnectNotifier(String token, String url, Integer appId, String mask) {
        this.token = token;
        this.url = url;
        this.appId = appId;
        this.mask = mask;
    }

    public String getToken() {
        return this.token;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getAppId() {
        return this.appId;
    }

    public String getMask() {
        return this.mask;
    }

    private String getToken(@Nonnull Run<?, ?> run) {
        Object tokenValue;
        if (StringUtils.isEmpty((String)this.getToken()) && (tokenValue = this.getParameterValue(run, "token")) != null) {
            this.token = tokenValue.toString();
        }
        return this.token;
    }

    private Object getParameterValue(@Nonnull Run<?, ?> run, String name) {
        for (Action ac : run.getAllActions()) {
            if (!(ac instanceof ParametersAction)) continue;
            ParametersAction pac = (ParametersAction)ac;
            for (ParameterValue pav : pac.getParameters()) {
                if (name == null || !name.equals(pav.getName())) continue;
                return pav.getValue();
            }
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        OutputUtils outputUtil = OutputUtils.getLoggerForStream(taskListener.getLogger());
        outputUtil.info("-----* Connect plugin is processing build artifacts *-----");
        Result result = run.getResult();
        if (result == null) {
            return;
        }
        if (result.isWorseOrEqualTo(Result.FAILURE)) {
            outputUtil.error("Cannot send artifacts from failed build.");
            return;
        }
        if (this.getAppId() == null) {
            outputUtil.error("No appId parameter provided.");
            return;
        }
        if (StringUtils.isEmpty((String)this.getMask())) {
            outputUtil.error("No mask parameter provided.");
            return;
        }
        if (StringUtils.isEmpty((String)this.getToken(run))) {
            outputUtil.error("No token parameter provided.");
            return;
        }
        if (StringUtils.isEmpty((String)this.getUrl())) {
            outputUtil.error("No url parameter provided.");
            return;
        }
        MultipartBuilder multipart = new MultipartBuilder();
        multipart.type(MultipartBuilder.FORM);
        try {
            byte[] bytes;
            FilePath artifact = this.getArtifact(filePath, this.getMask(), taskListener.getLogger());
            outputUtil.info(String.format("Artifact %s being sent to Incapptic Connect.", artifact.getName()));
            String ident = String.format("artifact-%s", this.getAppId());
            File tmp = File.createTempFile(ident, "tmp");
            try (FileOutputStream os = new FileOutputStream(tmp);){
                artifact.copyTo((OutputStream)os);
            }
            var13_12 = null;
            try (FileInputStream is = new FileInputStream(tmp);){
                bytes = IOUtils.toByteArray((InputStream)is);
            }
            catch (Throwable throwable) {
                var13_12 = throwable;
                throw throwable;
            }
            RequestBody rb = RequestBody.create((MediaType)MEDIA_TYPE, (byte[])bytes);
            multipart.addFormDataPart(ident, artifact.getName(), rb);
        }
        catch (MultipleArtifactsException e) {
            outputUtil.error(String.format("Multiple artifacts found for name [%s].", this.getMask()));
            return;
        }
        catch (ArtifactsNotFoundException e) {
            outputUtil.error(String.format("No artifacts found for name [%s].", this.getMask()));
            return;
        }
        catch (InterruptedException e) {
            outputUtil.error("Interrupted.");
            return;
        }
        Request.Builder builder = new Request.Builder();
        builder.addHeader(TOKEN_HEADER_NAME, this.getToken());
        builder.url(this.url);
        builder.post(multipart.build());
        Request request = builder.build();
        OkHttpClient client = new OkHttpClient();
        Response response = client.newCall(request).execute();
        if (!response.isSuccessful()) {
            if (response.code() < 500) {
                String body = IOUtils.toString((InputStream)response.body().byteStream(), (String)"UTF-8");
                outputUtil.error(String.format("Endpoint %s replied with code %d and message [%s].", this.getUrl(), response.code(), body));
            } else {
                outputUtil.error(String.format("Endpoint %s replied with code %d.", this.getUrl(), response.code()));
            }
        } else {
            outputUtil.success("All artifacts sent to Connect");
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            return false;
        }
        this.perform((Run<?, ?>)build, workspace, launcher, (TaskListener)listener);
        return true;
    }

    private FilePath getArtifact(FilePath workspace, String glob, PrintStream logger) throws MultipleArtifactsException, ArtifactsNotFoundException, IOException, InterruptedException {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(String.format("glob:%s", glob));
        ArrayList<FilePath> artifacts = new ArrayList<FilePath>();
        this.getArtifacts(workspace, "", matcher, artifacts, logger);
        if (artifacts.size() == 0) {
            throw new ArtifactsNotFoundException();
        }
        if (artifacts.size() > 1) {
            throw new MultipleArtifactsException();
        }
        return (FilePath)artifacts.get(0);
    }

    private void getArtifacts(FilePath parent, String base, PathMatcher matcher, List<FilePath> artifacts, PrintStream logger) throws IOException, InterruptedException {
        for (FilePath child : parent.list()) {
            if (child.isDirectory()) {
                this.getArtifacts(child, String.format("%s/%s", base, child.getName()), matcher, artifacts, logger);
                continue;
            }
            Path path = Paths.get(base, child.getName());
            if (!matcher.matches(path)) continue;
            artifacts.add(child);
        }
    }

    @Extension(ordinal=-1.0)
    @Symbol(value={"uploadToIncappticConnect"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(ConnectNotifier.class);
        }

        public String getDisplayName() {
            return "Incapptic Connect Publisher";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doCheckToken(@QueryParameter String token) {
            if (StringUtils.isEmpty((String)token)) {
                return FormValidation.error((String)"Empty token");
            }
            return FormValidation.ok();
        }
    }
}

