/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.jenkins.buildtype.install_packages.template;

import com.google.common.base.CaseFormat;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.BuildConfiguration;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.ConfigSection;
import com.groupon.jenkins.util.ResourceUtils;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.github.GHRepository;

public class DotCiTemplate
implements ExtensionPoint {
    private String ymlDefintion;
    private static Map<String, DotCiTemplate> templates;

    public static ExtensionList<DotCiTemplate> all() {
        return Jenkins.getInstance().getExtensionList(DotCiTemplate.class);
    }

    private String getName() {
        String className = this.getClass().getSimpleName();
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, className);
    }

    public BuildConfiguration getMergedTemplate(BuildConfiguration configuration, String parentTemplate, Map<String, Object> envVars) {
        return this.getMergedTemplate(configuration, this.getTemplates().get(parentTemplate), envVars);
    }

    public BuildConfiguration getMergedTemplate(BuildConfiguration configuration, DotCiTemplate parentTemplate, Map<String, Object> envVars) {
        BuildConfiguration parentBuildConfiguration = parentTemplate.getBuildConfiguration(envVars);
        parentBuildConfiguration.merge((ConfigSection)configuration);
        return parentBuildConfiguration;
    }

    Map<String, DotCiTemplate> getTemplates() {
        if (templates == null) {
            this.loadTemplates();
        }
        return templates;
    }

    public BuildConfiguration getBuildConfiguration(Map<String, Object> envVars) {
        BuildConfiguration buildConfiguration = new BuildConfiguration(this.ymlDefintion, envVars);
        if (!buildConfiguration.isBaseTemplate()) {
            return this.getMergedTemplate(buildConfiguration, buildConfiguration.getParentTemplate(), envVars);
        }
        return buildConfiguration;
    }

    public synchronized void loadTemplates() {
        templates = new HashMap<String, DotCiTemplate>();
        for (DotCiTemplate template : DotCiTemplate.all()) {
            template.load();
            templates.put(template.getName(), template);
        }
    }

    private void load() {
        this.ymlDefintion = ResourceUtils.readResource(this.getClass(), (String)".ci.yml");
    }

    public DotCiTemplate getDefaultFor(GHRepository githubRepository) {
        for (DotCiTemplate template : this.getTemplates().values()) {
            if (!template.isDefault(githubRepository)) continue;
            return template;
        }
        return null;
    }

    protected boolean isDefault(GHRepository githubRepository) {
        return false;
    }
}

