/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.jenkins.buildtype.install_packages.buildconfiguration;

import com.google.common.base.Joiner;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.ConfigSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.LanguageSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.LanguageVersionsSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.configvalue.ListOrSingleValue;
import com.groupon.jenkins.buildtype.util.shell.ShellCommands;
import hudson.matrix.Combination;
import java.util.ArrayList;

public class PackagesSection
extends ConfigSection<ListOrSingleValue<String>> {
    public static final String NAME = "packages";
    private final LanguageVersionsSection languageVersionsSection;
    private final LanguageSection languageSection;

    protected PackagesSection(ListOrSingleValue<String> configValue, LanguageSection languageSection, LanguageVersionsSection languageVersionsSection) {
        super(NAME, configValue, ConfigSection.MergeStrategy.APPEND);
        this.languageSection = languageSection;
        this.languageVersionsSection = languageVersionsSection;
    }

    @Override
    public ShellCommands toScript(Combination combination) {
        return new ShellCommands(new String[]{this.getInstallPackagesScript(combination)});
    }

    protected String getInstallPackagesScript(Combination combination) {
        ArrayList<String> allPackages = new ArrayList<String>();
        if (!"unknown".equalsIgnoreCase(this.languageSection.getLanguage())) {
            String languageVersion = (String)combination.get((Object)"language_version");
            if (languageVersion == null) {
                languageVersion = (String)((ListOrSingleValue)((Object)this.languageVersionsSection.getConfigValue())).getValues().get(0);
            }
            allPackages.add(this.languageSection.getLanguage() + "-" + languageVersion);
        }
        allPackages.addAll(((ListOrSingleValue)((Object)this.getConfigValue())).getValues());
        return "install_packages " + Joiner.on((String)" ").join(allPackages);
    }
}

