/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.jenkins.buildtype.install_packages.buildconfiguration;

import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.CompositeConfigSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.LanguageSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.LanguageVersionsSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.PackagesSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.VarsSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.configvalue.ListOrSingleValue;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.configvalue.MapValue;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.configvalue.StringValue;
import java.util.List;

public class EnvironmentSection
extends CompositeConfigSection {
    public static final String NAME = "environment";
    private final LanguageVersionsSection languageVersionsSection = new LanguageVersionsSection(this.getSectionConfig("language_versions", ListOrSingleValue.class));
    private final LanguageSection languageSection = new LanguageSection(this.getSectionConfig("language", StringValue.class));
    private final VarsSection varsSection = new VarsSection(this.getSectionConfig("vars", MapValue.class));
    private final PackagesSection packagesSection = new PackagesSection(this.getSectionConfig("packages", ListOrSingleValue.class), this.languageSection, this.languageVersionsSection);
    public final String DEFAULT_LINK_PROXY = "if [ -x /usr/bin/socat ]; then env | grep _TCP= | sed 's/.*_PORT_\\([0-9]*\\)_TCP=tcp:\\/\\/\\(.*\\):\\(.*\\)/socat TCP4-LISTEN:\\1,fork,reuseaddr TCP4:\\2:\\3 \\&/' | sh ;fi && ";

    public EnvironmentSection(MapValue<String, ?> config) {
        super(NAME, config);
        this.setSubSections(this.packagesSection, this.varsSection, this.languageSection, this.languageVersionsSection);
    }

    public boolean isMultiLanguageVersions() {
        return this.languageVersionsSection.isMultiLanguageVersions();
    }

    public List<String> getLanguageVersions() {
        return this.languageVersionsSection.getLanguageVersions();
    }

    public String getLanguage() {
        return this.languageSection.getLanguage();
    }

    public PackagesSection getPackagesSection() {
        return this.packagesSection;
    }

    public String buildCommandAmbassador(String buildCommand) {
        String shellPrefix = "sh -c \"env && ";
        if (buildCommand.contains(shellPrefix)) {
            int defaultEnvLength = shellPrefix.length();
            return new StringBuilder(buildCommand).insert(defaultEnvLength, "if [ -x /usr/bin/socat ]; then env | grep _TCP= | sed 's/.*_PORT_\\([0-9]*\\)_TCP=tcp:\\/\\/\\(.*\\):\\(.*\\)/socat TCP4-LISTEN:\\1,fork,reuseaddr TCP4:\\2:\\3 \\&/' | sh ;fi && ").toString();
        }
        return buildCommand;
    }
}

