/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.jenkins.buildtype.install_packages.buildconfiguration;

import com.google.common.collect.Iterables;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.configvalue.ConfigValue;
import com.groupon.jenkins.buildtype.util.shell.ShellCommands;
import hudson.matrix.Combination;
import java.util.Arrays;
import java.util.Collections;

public abstract class ConfigSection<T extends ConfigValue<?>> {
    protected T configValue;
    private final String name;
    private final MergeStrategy mergeStrategy;

    protected ConfigSection(String name, T configValue, MergeStrategy mergeStrategy) {
        this.name = name;
        this.mergeStrategy = mergeStrategy;
        this.configValue = configValue;
    }

    public abstract ShellCommands toScript(Combination var1);

    protected void merge(ConfigSection<T> otherConfigSection) {
        if (!((ConfigValue)((Object)otherConfigSection.getConfigValue())).isEmpty()) {
            if (this.mergeStrategy.equals((Object)MergeStrategy.REPLACE)) {
                ((ConfigValue)((Object)this.configValue)).replace((ConfigValue<?>)((Object)otherConfigSection.configValue));
            } else {
                ((ConfigValue)((Object)this.configValue)).append((ConfigValue<?>)((Object)otherConfigSection.configValue));
            }
        }
    }

    protected T getConfigValue() {
        return this.configValue;
    }

    protected void setConfigValue(T config) {
        this.configValue = config;
    }

    protected String getName() {
        return this.name;
    }

    public boolean isValid() {
        return Iterables.isEmpty(this.getValidationErrors());
    }

    public Iterable<String> getValidationErrors() {
        if (((ConfigValue)((Object)this.getConfigValue())).isValid()) {
            return Collections.emptyList();
        }
        return Arrays.asList(String.format("Invalid format for: %s", this.getName()));
    }

    protected Object getFinalConfigValue() {
        return ((ConfigValue)((Object)this.getConfigValue())).getValue();
    }

    public boolean isSpecified() {
        return !((ConfigValue)((Object)this.getConfigValue())).isEmpty();
    }

    protected static enum MergeStrategy {
        REPLACE,
        APPEND;

    }
}

