/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.jenkins.buildtype.install_packages.buildconfiguration;

import com.groupon.jenkins.buildtype.InvalidBuildConfigurationException;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.BuildConfiguration;
import com.groupon.jenkins.buildtype.install_packages.template.DotCiTemplate;
import com.groupon.jenkins.github.services.GithubRepositoryService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GHContent;

public class BuildConfigurationCalculator {
    public BuildConfiguration calculateBuildConfiguration(String githubRepoUrl, String sha, Map<String, Object> envVars) throws IOException, InterruptedException, InvalidBuildConfigurationException {
        GithubRepositoryService githubRepositoryService = this.getGithubRepositoryService(githubRepoUrl);
        DotCiTemplate dotCiTemplate = new DotCiTemplate();
        try {
            GHContent file = githubRepositoryService.getGHFile(".ci.yml", sha);
            BuildConfiguration configuration = new BuildConfiguration(IOUtils.toString((InputStream)file.read(), (Charset)Charset.defaultCharset()), envVars);
            if (!configuration.isValid()) {
                throw new InvalidBuildConfigurationException(configuration.getValidationErrors());
            }
            if (configuration.getLanguage() == null) {
                DotCiTemplate defaultParentTemplate = dotCiTemplate.getDefaultFor(githubRepositoryService.getGithubRepository());
                return dotCiTemplate.getMergedTemplate(configuration, defaultParentTemplate, envVars);
            }
            return dotCiTemplate.getMergedTemplate(configuration, configuration.getLanguage(), envVars);
        }
        catch (FileNotFoundException e) {
            return dotCiTemplate.getDefaultFor(githubRepositoryService.getGithubRepository()).getBuildConfiguration(envVars);
        }
    }

    protected GithubRepositoryService getGithubRepositoryService(String githubRepoUrl) {
        return new GithubRepositoryService(githubRepoUrl);
    }
}

