/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.jenkins.buildtype.install_packages;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.groupon.jenkins.buildtype.InvalidBuildConfigurationException;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.BuildConfiguration;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.BuildConfigurationCalculator;
import com.groupon.jenkins.buildtype.plugins.DotCiPluginAdapter;
import com.groupon.jenkins.buildtype.util.shell.ShellCommands;
import com.groupon.jenkins.buildtype.util.shell.ShellScriptRunner;
import com.groupon.jenkins.dynamic.build.DynamicBuild;
import com.groupon.jenkins.dynamic.build.DynamicSubBuild;
import com.groupon.jenkins.dynamic.build.execution.BuildExecutionContext;
import com.groupon.jenkins.dynamic.build.execution.SubBuildRunner;
import com.groupon.jenkins.dynamic.build.execution.SubBuildScheduler;
import com.groupon.jenkins.dynamic.buildtype.BuildType;
import com.groupon.jenkins.notifications.PostBuildNotifier;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.Combination;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class InstallPackagesBuild
extends BuildType
implements SubBuildRunner {
    private static final Logger LOGGER = Logger.getLogger(InstallPackagesBuild.class.getName());
    private BuildConfiguration buildConfiguration;

    public String getDescription() {
        return "Install Packages";
    }

    public Result runBuild(DynamicBuild dynamicBuild, BuildExecutionContext buildExecutionContext, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.buildConfiguration = this.calculateBuildConfiguration(dynamicBuild, listener);
        if (this.buildConfiguration.isSkipped()) {
            dynamicBuild.skip();
            return Result.SUCCESS;
        }
        dynamicBuild.setAxisList(this.getAxisList(this.buildConfiguration));
        Result result = this.buildConfiguration.isParallized() ? this.runMultiConfigbuildRunner(dynamicBuild, this.buildConfiguration, listener, launcher) : this.runSingleConfigBuild(dynamicBuild, new Combination((Map)ImmutableMap.of((Object)"script", (Object)"main")), this.buildConfiguration, buildExecutionContext, listener, launcher);
        this.runPlugins(dynamicBuild, this.buildConfiguration.getPlugins(), listener, launcher);
        this.runNotifiers(dynamicBuild, this.buildConfiguration, listener);
        return result;
    }

    private boolean runNotifiers(DynamicBuild build, BuildConfiguration buildConfiguration, BuildListener listener) {
        boolean result = true;
        List<PostBuildNotifier> notifiers = buildConfiguration.getNotifiers();
        for (PostBuildNotifier notifier : notifiers) {
            result &= notifier.perform(build, listener);
        }
        return result;
    }

    public Result runSubBuild(Combination combination, BuildExecutionContext dynamicSubBuildExecution, BuildListener listener) throws IOException, InterruptedException {
        return this.runBuildCombination(combination, dynamicSubBuildExecution, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result runMultiConfigbuildRunner(final DynamicBuild dynamicBuild, final BuildConfiguration buildConfiguration, final BuildListener listener, Launcher launcher) throws InterruptedException, IOException {
        SubBuildScheduler subBuildScheduler = new SubBuildScheduler(dynamicBuild, (SubBuildRunner)this, new SubBuildScheduler.SubBuildFinishListener(){

            public void runFinished(DynamicSubBuild subBuild) throws IOException {
                for (DotCiPluginAdapter plugin : buildConfiguration.getPlugins()) {
                    plugin.runFinished(subBuild, dynamicBuild, listener);
                }
            }
        });
        try {
            Iterable axisList = this.getAxisList(buildConfiguration).list();
            Result combinedResult = subBuildScheduler.runSubBuilds(this.getMainRunCombinations(axisList), listener);
            if (combinedResult.equals(Result.SUCCESS) && !Iterables.isEmpty(this.getPostBuildCombination(axisList))) {
                Result runSubBuildResults = subBuildScheduler.runSubBuilds(this.getPostBuildCombination(axisList), listener);
                combinedResult = combinedResult.combine(runSubBuildResults);
            }
            dynamicBuild.setResult(combinedResult);
            Result result = combinedResult;
            return result;
        }
        finally {
            try {
                subBuildScheduler.cancelSubBuilds(listener.getLogger());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to cancel subbuilds", e);
            }
        }
    }

    private Result runSingleConfigBuild(DynamicBuild dynamicBuild, Combination combination, BuildConfiguration buildConfiguration, BuildExecutionContext buildExecutionContext, BuildListener listener, Launcher launcher) throws IOException, InterruptedException {
        return this.runBuildCombination(combination, buildExecutionContext, listener);
    }

    private void runPlugins(DynamicBuild dynamicBuild, List<DotCiPluginAdapter> plugins, BuildListener listener, Launcher launcher) {
        for (DotCiPluginAdapter plugin : plugins) {
            plugin.perform(dynamicBuild, launcher, listener);
        }
    }

    private Result runBuildCombination(Combination combination, BuildExecutionContext buildExecutionContext, BuildListener listener) throws IOException, InterruptedException {
        ShellCommands mainBuildScript = this.buildConfiguration.toScript(combination);
        return new ShellScriptRunner(buildExecutionContext, listener).runScript(mainBuildScript);
    }

    private BuildConfiguration calculateBuildConfiguration(DynamicBuild build, BuildListener listener) throws IOException, InterruptedException, InvalidBuildConfigurationException {
        return new BuildConfigurationCalculator().calculateBuildConfiguration(build.getGithubRepoUrl(), build.getSha(), build.getEnvironmentWithChangeSet((TaskListener)listener));
    }

    private AxisList getAxisList(BuildConfiguration buildConfiguration) {
        AxisList axisList = new AxisList(new Axis[]{new Axis("script", "main")});
        if (buildConfiguration.isMultiLanguageVersions() && buildConfiguration.isMultiScript()) {
            axisList = new AxisList(new Axis[]{new Axis("language_version", buildConfiguration.getLanguageVersions()), new Axis("script", buildConfiguration.getScriptKeys())});
        } else if (buildConfiguration.isMultiLanguageVersions()) {
            axisList = new AxisList(new Axis[]{new Axis("language_version", buildConfiguration.getLanguageVersions())});
        } else if (buildConfiguration.isMultiScript()) {
            axisList = new AxisList(new Axis[]{new Axis("script", buildConfiguration.getScriptKeys())});
        }
        return axisList;
    }

    public List<Combination> getPostBuildCombination(Iterable<Combination> axisList) {
        for (Combination combination : axisList) {
            if (!this.isPostBuild(combination)) continue;
            return Arrays.asList(combination);
        }
        return Collections.emptyList();
    }

    private boolean isPostBuild(Combination combination) {
        return "post_build".equals(combination.get((Object)"script"));
    }

    public Iterable<Combination> getMainRunCombinations(Iterable<Combination> axisList) {
        return Iterables.filter(axisList, (Predicate)new Predicate<Combination>(){

            public boolean apply(Combination combination) {
                return !InstallPackagesBuild.this.isPostBuild(combination);
            }
        });
    }
}

