/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.jenkins.buildtype.install_packages;

import com.groupon.jenkins.buildtype.install_packages.GitConfig;
import com.groupon.jenkins.dynamic.build.DynamicProject;
import com.groupon.jenkins.git.GitUrl;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.IOException;

@Extension
public class GitCloneEnvContributor
extends EnvironmentContributor {
    public void buildEnvironmentFor(Job job, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
        if (job instanceof DynamicProject) {
            DynamicProject dynamicJob = (DynamicProject)job;
            GitUrl gitUrl = new GitUrl(dynamicJob.getGithubRepoUrl());
            envs.put("DOTCI_INSTALL_PACKAGES_GIT_CLONE_URL", this.getCloneUrl(gitUrl));
        }
    }

    private String getCloneUrl(GitUrl gitUrl) {
        String cloneTemplate = GitConfig.get().getCloneUrlTemplate();
        return gitUrl.applyTemplate(cloneTemplate);
    }
}

