/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.jenkins.buildtype.install_packages.buildconfiguration;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.ConfigSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.configvalue.ConfigValue;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.configvalue.MapValue;
import com.groupon.jenkins.buildtype.util.shell.ShellCommands;
import hudson.matrix.Combination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CompositeConfigSection
extends ConfigSection<MapValue<String, ?>> {
    private ConfigSection[] subSections;

    protected CompositeConfigSection(String name, MapValue<String, ?> config) {
        super(name, config, ConfigSection.MergeStrategy.APPEND);
    }

    protected void setSubSections(ConfigSection ... subSections) {
        this.subSections = subSections;
    }

    @Override
    public void merge(ConfigSection otherConfigSection) {
        for (int i = 0; i < this.subSections.length; ++i) {
            this.subSections[i].merge(((CompositeConfigSection)otherConfigSection).subSections[i]);
        }
    }

    @Override
    public ShellCommands toScript(Combination combination) {
        ArrayList<ShellCommands> subPhases = new ArrayList<ShellCommands>(this.subSections.length);
        for (int i = 0; i < this.subSections.length; ++i) {
            subPhases.add(this.subSections[i].toScript(combination));
        }
        return ShellCommands.combine(subPhases);
    }

    private Iterable<String> validateForRedundantKeys(Iterable<String> allowedKeys) {
        if (((MapValue)((Object)this.getConfigValue())).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList specifiedKeys = new ArrayList(((Map)((MapValue)((Object)this.getConfigValue())).getValue()).keySet());
        for (String allowedKey : allowedKeys) {
            specifiedKeys.remove(allowedKey);
        }
        return Iterables.transform(specifiedKeys, (Function)new Function<String, String>(){

            public String apply(String input) {
                return String.format("Unrecognized key %s in %s", input, CompositeConfigSection.this.getName());
            }
        });
    }

    @Override
    public Iterable<String> getValidationErrors() {
        Iterable errors = super.getValidationErrors();
        if (Iterables.isEmpty(errors)) {
            int i;
            ArrayList<String> allowedKeys = new ArrayList<String>(this.subSections.length);
            for (i = 0; i < this.subSections.length; ++i) {
                allowedKeys.add(this.subSections[i].getName());
            }
            errors = Iterables.concat(errors, this.validateForRedundantKeys(allowedKeys));
            for (i = 0; i < this.subSections.length; ++i) {
                errors = Iterables.concat((Iterable)errors, this.subSections[i].getValidationErrors());
            }
        }
        return errors;
    }

    protected <T extends ConfigValue<?>> T getSectionConfig(String name, Class<T> configValueType) {
        return ((MapValue)((Object)this.getConfigValue())).getConfigValue(name, configValueType);
    }

    @Override
    protected Object getFinalConfigValue() {
        HashMap<String, Object> finalConfig = new HashMap<String, Object>(this.subSections.length);
        for (ConfigSection configSection : this.subSections) {
            finalConfig.put(configSection.getName(), configSection.getFinalConfigValue());
        }
        return finalConfig;
    }
}

