/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.jenkins.buildtype.install_packages.buildconfiguration;

import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.BuildSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.CompositeConfigSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.EnvironmentSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.NotificationsSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.ParentTemplateSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.PluginsSection;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.configvalue.ListValue;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.configvalue.MapValue;
import com.groupon.jenkins.buildtype.install_packages.buildconfiguration.configvalue.StringValue;
import com.groupon.jenkins.buildtype.plugins.DotCiPluginAdapter;
import com.groupon.jenkins.notifications.PostBuildNotifier;
import com.groupon.jenkins.util.GroovyYamlTemplateProcessor;
import java.util.List;
import java.util.Map;

public class BuildConfiguration
extends CompositeConfigSection {
    private EnvironmentSection environmentSection;
    protected BuildSection buildSection;
    private NotificationsSection notificationsSection;
    private PluginsSection pluginsSection;
    private ParentTemplateSection parentTemplateSection;

    public BuildConfiguration(String ymlDefintion, Map<String, Object> envVars) {
        this(new MapValue(new GroovyYamlTemplateProcessor(ymlDefintion, envVars).getConfig()));
    }

    public BuildConfiguration(MapValue<String, ?> config) {
        super(".ci.yml", config);
        this.setSections();
    }

    private void setSections() {
        this.parentTemplateSection = new ParentTemplateSection(this.getSectionConfig("parent_template", StringValue.class));
        this.environmentSection = new EnvironmentSection(this.getSectionConfig("environment", MapValue.class));
        this.buildSection = new BuildSection(this.getSectionConfig("build", MapValue.class));
        this.notificationsSection = new NotificationsSection(this.getSectionConfig("notifications", ListValue.class));
        this.pluginsSection = new PluginsSection(this.getSectionConfig("plugins", ListValue.class));
        this.setSubSections(this.environmentSection, this.buildSection, this.notificationsSection, this.pluginsSection);
    }

    public String getParentTemplate() {
        return (String)((StringValue)((Object)this.parentTemplateSection.getConfigValue())).getValue();
    }

    public boolean isSkipped() {
        return this.buildSection.isSkipped();
    }

    public List<PostBuildNotifier> getNotifiers() {
        return this.notificationsSection.getNotifiers();
    }

    public boolean isMultiLanguageVersions() {
        return this.environmentSection.isMultiLanguageVersions();
    }

    public boolean isMultiScript() {
        return this.buildSection.isMultiScript();
    }

    public List<String> getLanguageVersions() {
        return this.environmentSection.getLanguageVersions();
    }

    public List<DotCiPluginAdapter> getPlugins() {
        return this.pluginsSection.getPlugins();
    }

    public List<String> getScriptKeys() {
        return this.buildSection.getScriptKeys();
    }

    public String getLanguage() {
        return this.environmentSection.getLanguage();
    }

    public boolean isParallized() {
        return this.isMultiScript() || this.isMultiLanguageVersions();
    }

    public boolean isBaseTemplate() {
        return !this.parentTemplateSection.isSpecified();
    }
}

