/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.jenkinsci.plugins.DotCiFigtemplate;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class HelloWorldBuilder
extends Builder {
    private final String name;

    @DataBoundConstructor
    public HelloWorldBuilder(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        if (this.getDescriptor().getUseFrench()) {
            listener.getLogger().println("Bonjour, " + this.name + "!");
        } else {
            listener.getLogger().println("Hello, " + this.name + "!");
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private boolean useFrench;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a name");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Say hello world";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.useFrench = formData.getBoolean("useFrench");
            this.save();
            return super.configure(req, formData);
        }

        public boolean getUseFrench() {
            return this.useFrench;
        }
    }
}

