/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.jenkins.digitalocean;

import com.dubture.jenkins.digitalocean.DigitalOceanComputer;
import com.dubture.jenkins.digitalocean.Slave;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import hudson.slaves.CloudSlaveRetentionStrategy;
import java.util.concurrent.TimeUnit;

public class RetentionStrategy
extends CloudSlaveRetentionStrategy<DigitalOceanComputer> {
    public void start(DigitalOceanComputer digitalOceanComputer) {
        digitalOceanComputer.connect(false);
    }

    protected long checkCycle() {
        return 1L;
    }

    protected boolean isIdleForTooLong(DigitalOceanComputer digitalOceanComputer) {
        Slave node = (Slave)digitalOceanComputer.getNode();
        if (node == null) {
            return false;
        }
        int idleTerminationTime = node.getIdleTerminationTime();
        if (idleTerminationTime == 0) {
            return false;
        }
        if (idleTerminationTime > 0) {
            return System.currentTimeMillis() - digitalOceanComputer.getIdleStartMilliseconds() > TimeUnit.MINUTES.toMillis(idleTerminationTime);
        }
        if (idleTerminationTime < 0 && digitalOceanComputer.isIdle()) {
            long uptimeMinutes = TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - digitalOceanComputer.getStartTimeMillis());
            if (uptimeMinutes < 60L) {
                return false;
            }
            while (uptimeMinutes >= 60L) {
                uptimeMinutes -= 60L;
            }
            return uptimeMinutes >= 25L && uptimeMinutes < 30L;
        }
        return false;
    }

    private static class DescriptorImpl
    extends Descriptor<hudson.slaves.RetentionStrategy<?>> {
        private DescriptorImpl() {
        }

        @NonNull
        public String getDisplayName() {
            return "DigitalOcean";
        }
    }
}

