package com.compuware.ispw.restapi;

import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

import hudson.Extension;

public class RegisterWebhookStep extends Step {

    @DataBoundConstructor
    public RegisterWebhookStep() {

    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new RegisterWebhookExecution(context);
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl) super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl extends AbstractStepDescriptorImpl {

        public DescriptorImpl() {
            super(RegisterWebhookExecution.class);
        }

        @Override
        public String getFunctionName() {
            return "ispwRegisterWebhook";
        }

        @Override
        public String getDisplayName() {
            return "Creates and returns a ISPW webhook that can be used by an external system to notify a pipeline";
        }
    }
}
