/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps;

import com.cloudbees.groovy.cps.AbstractGroovyCpsTest;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.CpsTransformer;
import com.cloudbees.groovy.cps.TransformerConfiguration;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SafepointTest
extends AbstractGroovyCpsTest {
    private static final Object SAFEPOINT = "Yo!";

    @Override
    protected CpsTransformer createCpsTransformer() {
        CpsTransformer t = super.createCpsTransformer();
        t.setConfiguration(new TransformerConfiguration().withSafepoint(SafepointTest.class, "safepoint"));
        return t;
    }

    @Test
    public void whileLoop() throws Throwable {
        Assert.assertEquals((Object)SAFEPOINT, (Object)this.evalCPSonly("while (true) ;"));
    }

    @Ignore(value="Groovy 2.x doesn't support do-while loops")
    @Test
    public void doWhileLoop() throws Throwable {
        Assert.assertEquals((Object)SAFEPOINT, (Object)this.evalCPSonly("do { } while (true) ;"));
    }

    @Test
    public void forLoop() throws Throwable {
        Assert.assertEquals((Object)SAFEPOINT, (Object)this.evalCPSonly("for (;;) { }"));
    }

    @Test
    public void recursion() throws Throwable {
        Assert.assertEquals((Object)SAFEPOINT, (Object)this.evalCPSonly("def foo() { foo() }; foo();"));
    }

    @Test
    public void closure() throws Throwable {
        Assert.assertEquals((Object)SAFEPOINT, (Object)this.evalCPSonly("def x = { -> }; x();"));
    }

    public static void safepoint() {
        Continuable.suspend((Object)SAFEPOINT);
    }
}

