/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.AbstractGroovyCpsTest;
import java.util.List;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class FunctionCallBlockTest
extends AbstractGroovyCpsTest {
    public static void someSyncCode(int i) throws Exception {
        if (i <= 0) {
            throw new NamingException();
        }
        FunctionCallBlockTest.someSyncCode(i - 1);
    }

    @Test
    public void infiniteRecursion() {
        try {
            this.evalCPSonly("def thing = null\ndef getThing() {\n    return thing == null\n}\ndef stuff = getThing()\n");
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Throwable t) {
            MatcherAssert.assertThat((Object)t.toString(), (Matcher)CoreMatchers.equalTo((Object)"java.lang.StackOverflowError: Excessively nested closures/functions at Script1.getThing(Script1.groovy:3) - look for unbounded recursion - call depth: 1025"));
        }
    }

    @Test
    public void stackTraceFixup() throws Throwable {
        List<StackTraceElement> elements = List.of((StackTraceElement[])this.evalCPSonly("\n\ndef x() {\n  y()\n}\n\ndef y() {\n  FunctionCallBlockTest.someSyncCode(3)\n}\ntry {\n  x()\n} catch (Exception e) {\n  return e.stackTrace\n}\n"));
        List traces = elements.stream().map(Object::toString).collect(Collectors.toList());
        MatcherAssert.assertThat(traces, (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"Script1.y(Script1.groovy:8)"), CoreMatchers.containsString((String)"Script1.x(Script1.groovy:4)"), CoreMatchers.containsString((String)"Script1.run(Script1.groovy:11)"), CoreMatchers.containsString((String)"___cps.transform___(Native Method)"), CoreMatchers.containsString((String)"com.cloudbees.groovy.cps.impl.ContinuationGroup.methodCall")}));
        MatcherAssert.assertThat(traces, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.containsString((String)"com.cloudbees.groovy.cps.impl.FunctionCallBlockTest.someSyncCode(FunctionCallBlockTest.java:")));
    }
}

