/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ims;

import com.bmc.ims.DlistRecord;
import com.bmc.ims.DlpLoadLib;
import com.bmc.ims.JCLService;
import com.bmc.ims.ResponseObject;
import groovy.lang.Binding;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.verb.POST;

@Extension
public class BmcDlpBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private String server;
    private String port;
    private String user;
    private String jclContent;
    private String jclType;
    private String dlist;
    private String jobCard;
    private String acctno;
    private String dPds;
    private String dOptionsPds;
    private String target;
    private String mode;
    private String ims_cmd;
    private String title;
    private String notes;
    private String vds;
    private String goodRC;
    private boolean dependent;
    private boolean coord;
    private boolean mark;
    private List<DlistRecord> dlistRecords = new ArrayList<DlistRecord>();
    private List<DlpLoadLib> dlpLoadLibs = new ArrayList<DlpLoadLib>();
    private JCLService zosmf = null;
    private String groovyScript;
    private SecureGroovyScript script;
    private Secret pswd;

    public BmcDlpBuilder() {
    }

    @DataBoundConstructor
    public BmcDlpBuilder(String server, String port, String user, String pswd, String jclContent, String jclType, String dlist, String jobCard, String acctno, String dPds, String dOptionsPds, String target, String mode, String ims_cmd, String title, String notes, List<DlistRecord> dlistRecords, List<DlpLoadLib> dlpLoadLibs, String vds, String goodRC, boolean dependent, boolean mark, boolean coord) {
        this.dlistRecords = dlistRecords;
        this.dlpLoadLibs = dlpLoadLibs;
        this.server = server;
        this.port = port;
        this.user = user;
        this.pswd = Secret.fromString((String)pswd);
        this.jclContent = jclContent;
        this.jclType = jclType;
        this.dlist = dlist;
        this.jobCard = jobCard;
        this.acctno = acctno;
        this.dPds = dPds;
        this.target = target;
        this.mode = mode;
        this.ims_cmd = ims_cmd;
        this.dOptionsPds = dOptionsPds;
        this.title = title;
        this.notes = notes;
        this.vds = vds;
        this.goodRC = goodRC;
        this.dependent = dependent;
        this.mark = mark;
        this.coord = coord;
    }

    public List<DlistRecord> getDlistRecords() {
        return this.dlistRecords;
    }

    public void setDlistRecords(List<DlistRecord> dlistRecords) {
        this.dlistRecords = dlistRecords;
    }

    public List<DlpLoadLib> getDlpLoadLibs() {
        return this.dlpLoadLibs;
    }

    public void setDlpLoadLibs(List<DlpLoadLib> dlpLoadLibs) {
        this.dlpLoadLibs = dlpLoadLibs;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Secret getPswd() {
        return this.pswd;
    }

    public void setPswd(Secret pswd) {
        this.pswd = pswd;
    }

    public void setJclContent(String jclContent) {
        this.jclContent = jclContent;
    }

    public String getJclContent() {
        return this.jclContent;
    }

    public String getJclType() {
        return this.jclType;
    }

    public void setJclType(String jclType) {
        this.jclType = jclType;
    }

    public String getDlist() {
        return this.dlist;
    }

    public void setDlist(String dlist) {
        this.dlist = dlist;
    }

    public String getJobCard() {
        return this.jobCard;
    }

    public void setJobCard(String jobCard) {
        this.jobCard = jobCard;
    }

    public String getAcctno() {
        return this.acctno;
    }

    public void setAcctno(String acctno) {
        this.acctno = acctno;
    }

    public String getdPds() {
        return this.dPds;
    }

    public void setdPds(String dPds) {
        this.dPds = dPds;
    }

    public String getdOptionsPds() {
        return this.dOptionsPds;
    }

    public void setdOptionsPds(String dOptionsPds) {
        this.dOptionsPds = dOptionsPds;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getIms_cmd() {
        return this.ims_cmd;
    }

    public void setIms_cmd(String ims_cmd) {
        this.ims_cmd = ims_cmd;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getVds() {
        return this.vds;
    }

    public void setVds(String vds) {
        this.vds = vds;
    }

    public String getGoodRC() {
        return this.goodRC;
    }

    public void setGoodRC(String goodRC) {
        this.goodRC = goodRC;
    }

    public boolean isDependent() {
        return this.dependent;
    }

    public void setDependent(boolean dependent) {
        this.dependent = dependent;
    }

    public boolean isMark() {
        return this.mark;
    }

    public void setMark(boolean mark) {
        this.mark = mark;
    }

    public boolean isCoord() {
        return this.coord;
    }

    public void setCoord(boolean coord) {
        this.coord = coord;
    }

    private String inspectFailureInLogs(String log) {
        if (log.contains("$HASP395")) {
            if (log.indexOf("RC") != -1) {
                String actRC = log.substring(log.indexOf("RC") + 3, log.indexOf("RC") + 7);
                if (!actRC.equals("0000")) {
                    int goodRc = Integer.parseInt(this.goodRC);
                    int actualRc = Integer.parseInt(actRC);
                    if (actualRc > goodRc) {
                        return "RC=" + actRC;
                    }
                }
            } else if (log.indexOf("ABEND") != -1) {
                return "ABEND=" + log.substring(log.indexOf("ABEND") + 6, log.indexOf("ABEND") + 10);
            }
        } else {
            if (log.contains("IEF453I")) {
                return "JOB FAILED - JCL ERROR";
            }
            if (log.contains("IEFC452I")) {
                return "JOB NOT RUN - JCL ERROR";
            }
            if (log.contains("HASP106")) {
                return "JOB DELETED BY JES2 OR CANCELLED BY OPERATOR BEFORE EXECUTION ";
            }
        }
        return null;
    }

    private String adjustBodyTo72Chars(String body) {
        String processedBody = "";
        block0: while (body.length() > 0) {
            if (body.indexOf("\n") > 73) {
                for (int charsPerLine = 72; charsPerLine > 0; --charsPerLine) {
                    String delimiter = body.substring(charsPerLine, charsPerLine + 1);
                    if (!delimiter.equals(" ") && !delimiter.equals(",")) continue;
                    processedBody = processedBody.concat(body.substring(0, charsPerLine) + "\n");
                    body = body.substring(charsPerLine);
                    continue block0;
                }
                continue;
            }
            if (body.indexOf("\n") == -1) {
                processedBody = processedBody.concat(body);
                body = body.substring(0, 0);
                continue;
            }
            if (body.indexOf("\n") > 73) continue;
            processedBody = processedBody.concat(body.substring(0, body.indexOf("\n") + 1));
            body = body.substring(body.indexOf("\n") + 1);
        }
        return processedBody;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        ResponseObject resp = null;
        String url = "https://" + this.server + ":" + this.port + "/zosmf/restjobs/jobs";
        Properties headers = new Properties();
        String body = null;
        String jc = null;
        String jobname = null;
        String jobid = null;
        Object jobowner = null;
        Object jobstatus = null;
        Object jobtype = null;
        Object jobretcode = null;
        long starttime = 0L;
        long endtime = 0L;
        long waittime = 0L;
        Object jobCompletion = null;
        String compareRC = "0001";
        listener.getLogger().println("user: " + this.user);
        listener.getLogger().println("server: " + this.server);
        listener.getLogger().println("port: " + this.port);
        this.zosmf = new JCLService(true);
        this.zosmf.login(this.server, this.port, this.user, this.pswd.getPlainText(), listener);
        Binding binding = new Binding();
        binding.setVariable("ACCTNO", (Object)this.acctno.toUpperCase());
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            this.groovyScript = "\"\"\"" + this.jobCard + "\"\"\"";
            this.script = new SecureGroovyScript(this.groovyScript, false, null).configuringWithKeyItem();
            jc = this.script.evaluate(cl, binding).toString();
            binding.setVariable("JOB_CARD", (Object)jc.toUpperCase());
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Failed to evaluate groovy script."));
        }
        binding.setVariable("VARLIST", (Object)this.vds.toUpperCase());
        List<DlistRecord> itemlist = this.getDlistRecords();
        int indx = 0;
        for (DlistRecord i : itemlist) {
            binding.setVariable("ACTION" + String.valueOf(indx), (Object)i.getAction().toUpperCase());
            binding.setVariable("ELEMENT_TYPE" + String.valueOf(indx), (Object)i.getElementType().toUpperCase());
            binding.setVariable("ELEMENT_NAME" + String.valueOf(indx), (Object)i.getElementName().toUpperCase());
            binding.setVariable("IMS_COMMAND" + String.valueOf(indx), (Object)i.getIms_cmd().toUpperCase());
            if (i.getElementType().equals("APPLCTN")) {
                binding.setVariable("NEW" + String.valueOf(indx), (Object)i.getAppnewname().toUpperCase());
                binding.setVariable("RES" + String.valueOf(indx), (Object)i.getAppres().toUpperCase());
                binding.setVariable("FP" + String.valueOf(indx), (Object)i.getAppfp().toUpperCase());
                binding.setVariable("TLS" + String.valueOf(indx), (Object)i.getApptls().toUpperCase());
                binding.setVariable("COPYACB" + String.valueOf(indx), (Object)i.getAppcopyacb().toUpperCase());
                binding.setVariable("RELGSAM" + String.valueOf(indx), (Object)i.getApprelgsam().toUpperCase());
            } else if (i.getElementType().equals("DATABASE")) {
                binding.setVariable("NEW" + String.valueOf(indx), (Object)i.getDbnewname().toUpperCase());
                binding.setVariable("RES" + String.valueOf(indx), (Object)i.getDbres().toUpperCase());
                binding.setVariable("COPYACB" + String.valueOf(indx), (Object)i.getDbcopyacb().toUpperCase());
                binding.setVariable("RELGSAM" + String.valueOf(indx), (Object)i.getDbrelgsam().toUpperCase());
            } else if (i.getElementType().equals("TRANSACT")) {
                binding.setVariable("NEW" + String.valueOf(indx), (Object)i.getTrannewname().toUpperCase());
                binding.setVariable("FP" + String.valueOf(indx), (Object)i.getTranfp().toUpperCase());
                binding.setVariable("INQ" + String.valueOf(indx), (Object)i.getTraninq().toUpperCase());
                binding.setVariable("TLS" + String.valueOf(indx), (Object)i.getTrantls().toUpperCase());
            } else if (i.getElementType().equals("TERMINAL")) {
                binding.setVariable("NEW" + String.valueOf(indx), (Object)i.getTerminalnewname().toUpperCase());
                binding.setVariable("MASK" + String.valueOf(indx), (Object)i.getTerminalmask().toUpperCase());
            } else if (i.getElementType().equals("LTERM")) {
                binding.setVariable("NEW" + String.valueOf(indx), (Object)i.getLtermnewname().toUpperCase());
                binding.setVariable("MASK" + String.valueOf(indx), (Object)i.getLtermmask().toUpperCase());
            } else if (i.getElementType().equals("SUBPOOL")) {
                binding.setVariable("NEW" + String.valueOf(indx), (Object)i.getSubpoolnewname().toUpperCase());
                binding.setVariable("MASK" + String.valueOf(indx), (Object)i.getSubpoolmask().toUpperCase());
            } else if (i.getElementType().equals("RTCODE")) {
                binding.setVariable("NEW" + String.valueOf(indx), (Object)i.getRtcnewname().toUpperCase());
                binding.setVariable("INQ" + String.valueOf(indx), (Object)i.getRtcinq().toUpperCase());
            }
            binding.setVariable("ACC" + String.valueOf(indx), (Object)i.getAcc().toUpperCase());
            binding.setVariable("AUTO" + String.valueOf(indx), (Object)i.getAuto().toUpperCase());
            binding.setVariable("RAND" + String.valueOf(indx), (Object)i.getRand().toUpperCase());
            binding.setVariable("RANDONLY" + String.valueOf(indx), (Object)i.getRandonly().toUpperCase());
            binding.setVariable("RLDAREAS" + String.valueOf(indx), (Object)i.getRldareas().toUpperCase());
            binding.setVariable("IOVFEXT" + String.valueOf(indx), (Object)i.getIovfext().toUpperCase());
            binding.setVariable("TY" + String.valueOf(indx), (Object)i.getTy().toUpperCase());
            binding.setVariable("SCHD" + String.valueOf(indx), (Object)i.getSchd().toUpperCase());
            binding.setVariable("DYN" + String.valueOf(indx), (Object)i.getDyn().toUpperCase());
            binding.setVariable("GPSB" + String.valueOf(indx), (Object)i.getGpsb().toUpperCase());
            binding.setVariable("LANG" + String.valueOf(indx), (Object)i.getLang().toUpperCase());
            binding.setVariable("PSB" + String.valueOf(indx), (Object)i.getPsb().toUpperCase());
            binding.setVariable("WFI" + String.valueOf(indx), (Object)i.getWfi().toUpperCase());
            binding.setVariable("NPRI" + String.valueOf(indx), (Object)i.getNpri().toUpperCase());
            binding.setVariable("LPRI" + String.valueOf(indx), (Object)i.getLpri().toUpperCase());
            binding.setVariable("LCO" + String.valueOf(indx), (Object)i.getLco().toUpperCase());
            binding.setVariable("MSEG" + String.valueOf(indx), (Object)i.getMseg().toUpperCase());
            binding.setVariable("RESP" + String.valueOf(indx), (Object)i.getResp().toUpperCase());
            binding.setVariable("CL" + String.valueOf(indx), (Object)i.getCl().toUpperCase());
            binding.setVariable("PLC" + String.valueOf(indx), (Object)i.getPlc().toUpperCase());
            binding.setVariable("TIME" + String.valueOf(indx), (Object)i.getTime().toUpperCase());
            binding.setVariable("PARA" + String.valueOf(indx), (Object)i.getPara().toUpperCase());
            binding.setVariable("USCHD" + String.valueOf(indx), (Object)i.getUschd().toUpperCase());
            binding.setVariable("RECV" + String.valueOf(indx), (Object)i.getRecv().toUpperCase());
            binding.setVariable("EMHS" + String.valueOf(indx), (Object)i.getEmhs().toUpperCase());
            binding.setVariable("MPER" + String.valueOf(indx), (Object)i.getMper().toUpperCase());
            binding.setVariable("UC" + String.valueOf(indx), (Object)i.getUc().toUpperCase());
            binding.setVariable("EDIT" + String.valueOf(indx), (Object)i.getEdit().toUpperCase());
            binding.setVariable("LSID" + String.valueOf(indx), (Object)i.getLsid().toUpperCase());
            binding.setVariable("RSID" + String.valueOf(indx), (Object)i.getRsid().toUpperCase());
            binding.setVariable("SPA" + String.valueOf(indx), (Object)i.getSpa().toUpperCase());
            binding.setVariable("SPAD" + String.valueOf(indx), (Object)i.getSpad().toUpperCase());
            binding.setVariable("SEGS" + String.valueOf(indx), (Object)i.getSegs().toUpperCase());
            binding.setVariable("OSEG" + String.valueOf(indx), (Object)i.getOseg().toUpperCase());
            binding.setVariable("MSC" + String.valueOf(indx), (Object)i.getMsc().toUpperCase());
            binding.setVariable("DC" + String.valueOf(indx), (Object)i.getDc().toUpperCase());
            binding.setVariable("MREG" + String.valueOf(indx), (Object)i.getMreg().toUpperCase());
            binding.setVariable("SER" + String.valueOf(indx), (Object)i.getSer().toUpperCase());
            binding.setVariable("AOI" + String.valueOf(indx), (Object)i.getAoi().toUpperCase());
            binding.setVariable("EXPTM" + String.valueOf(indx), (Object)i.getExptm().toUpperCase());
            binding.setVariable("SIGN" + String.valueOf(indx), (Object)i.getSign().toUpperCase());
            binding.setVariable("ASS" + String.valueOf(indx), (Object)i.getAss().toUpperCase());
            binding.setVariable("MSN" + String.valueOf(indx), (Object)i.getMsn().toUpperCase());
            binding.setVariable("L61" + String.valueOf(indx), (Object)i.getL61().toUpperCase());
            binding.setVariable("MSEG" + String.valueOf(indx), (Object)i.getMseg().toUpperCase());
            binding.setVariable("MSG" + String.valueOf(indx), (Object)i.getMsg().toUpperCase());
            binding.setVariable("NAME" + String.valueOf(indx), (Object)i.getRtcpsbname().toUpperCase());
            ++indx;
        }
        List<DlpLoadLib> itemInLoadList = this.getDlpLoadLibs();
        int indx1 = 0;
        for (DlpLoadLib i : itemInLoadList) {
            binding.setVariable("DLP_LOAD" + String.valueOf(indx1), (Object)i.getLib().toUpperCase());
            ++indx1;
        }
        binding.setVariable("DLP_OPTIONS_PDS", (Object)this.dOptionsPds.toUpperCase());
        binding.setVariable("DELTA_PDS", (Object)this.dPds.toUpperCase());
        binding.setVariable("DELTA_LIST_NAME", (Object)this.dlist.toUpperCase());
        binding.setVariable("DELTA_LIST_TITLE", (Object)this.title.toUpperCase());
        binding.setVariable("NOTES", (Object)this.notes.toUpperCase());
        binding.setVariable("TGT", (Object)this.target.toUpperCase());
        binding.setVariable("MOD", (Object)this.mode.toUpperCase());
        try {
            this.groovyScript = "\"\"\"" + this.jclContent + "\"\"\"";
            this.script = new SecureGroovyScript(this.groovyScript, false, null).configuring(ApprovalContext.create());
            body = this.script.evaluate(cl, binding).toString().replace(",,", "");
            body = body.replace("(,", "(");
            body = body.replace(",)", ")");
            body = this.adjustBodyTo72Chars(body);
            listener.getLogger().println("body:\n" + body);
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Failed to evaluate groovy script."));
        }
        headers.put("Content-Type", "text/plain");
        headers.put("X-IBM-Intrdr-Class", "A");
        headers.put("X-IBM-Intrdr-Recfm", "F");
        headers.put("X-IBM-Intrdr-Lrecl", "80");
        headers.put("X-IBM-Intrdr-Mode", "TEXT");
        resp = this.zosmf.doRequest(url, "PUT", body, headers, listener);
        listener.getLogger().println("Server returned response code: " + resp.status + " " + resp.jobId);
        if (resp.status < 200 || resp.status > 299) {
            listener.getLogger().println("Error during job submission");
            run.setResult(Result.FAILURE);
            return;
        }
        jobname = resp.jobName;
        jobid = resp.jobId;
        listener.getLogger().println("Job " + jobid + " submitted successfully to " + this.server);
        boolean jobCompleted = false;
        int retcount = 1;
        try {
            url = "https://" + this.server + ":" + this.port + "/zosmf/restjobs/jobs/" + jobname + "/" + jobid;
            listener.getLogger().println("Waiting to retrieve job status...");
            headers = new Properties();
            headers.put("Content-Type", "application/json");
            body = "Obtain Job Status";
            while (!jobCompleted) {
                resp = this.zosmf.doRequest(url, "GET", body, headers, listener);
                if (resp.status == 400) {
                    run.setResult(Result.FAILURE);
                    return;
                }
                if (resp.jobStatus != null) {
                    listener.getLogger().println("Job Output Retrieval Attempt No= " + retcount + " status: " + resp.jobStatus);
                    if (resp.jobStatus.equals("OUTPUT") || resp.jobStatus.equals("PRINT")) {
                        jobCompleted = true;
                    }
                }
                ++retcount;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            listener.getLogger().println("Job status could not be retrieved");
            listener.getLogger().println(ex);
        }
        try {
            url = "https://" + this.server + ":" + this.port + "/zosmf/restjobs/jobs/" + jobname + "/" + jobid + "/files";
            listener.getLogger().println("HTTPS URL path to list the spool files: " + url);
            headers = new Properties();
            headers.put("Content-Type", "application/json");
            listener.getLogger().println("Waiting to retrieve list of job spool files...");
            body = "List spool files";
            resp = this.zosmf.doRequest(url, "GET", body, headers, listener);
            listener.getLogger().println("Server returned response code: " + resp.status);
            String message = "Additional diagnostic response messages:\n" + resp.statAndHeaders.toString();
            listener.getLogger().println(message);
        }
        catch (Exception ex) {
            listener.getLogger().println("List of job spool files could not be retrieved");
            ex.printStackTrace();
            listener.getLogger().println(ex);
        }
        StringBuffer append_data = new StringBuffer();
        String ACM_Security_temp = "";
        OutputStreamWriter w = null;
        PrintWriter pw = null;
        String logfilename = "";
        String logfileFolderPath = "";
        String errormsg = null;
        try {
            int i;
            int size = resp.idvalarr.size();
            ArrayList<String> idvalarr = new ArrayList<String>();
            ArrayList<String> ddnamevalarr = new ArrayList<String>();
            for (i = 0; i < size; ++i) {
                listener.getLogger().println("ID number of the job spool files= " + resp.idvalarr.get(i));
                idvalarr.add(resp.idvalarr.get(i));
                ddnamevalarr.add(resp.ddnamevalarr.get(i));
            }
            listener.getLogger().println("Before Job Log retrieval...");
            for (i = 0; i < size; ++i) {
                BufferedReader in;
                url = "https://" + this.server + ":" + this.port + "/zosmf/restjobs/jobs/" + jobname + "/" + jobid + "/files/" + (String)idvalarr.get(i) + "/records";
                listener.getLogger().println("HTTPS URL path to retrieve content of spool files: " + url);
                headers = new Properties();
                headers.put("Content-Type", "plain/text");
                body = "Retrieve spool files content";
                resp = this.zosmf.doRequest(url, "GET", body, headers, listener);
                listener.getLogger().println("Server returned response code for job spool file-" + (String)idvalarr.get(i) + ": " + resp.status);
                String message = "Additional diagnostic response messages:\n" + resp.statAndHeaders.toString();
                listener.getLogger().println(message);
                if (resp.ret_code == 8) {
                    listener.getLogger().println(resp.resp_details);
                    throw new Exception();
                }
                if (resp.status >= 200 && resp.status <= 299) {
                    String inputLine;
                    listener.getLogger().println("Writing the Job Log to workspace");
                    logfilename = (String)ddnamevalarr.get(i);
                    logfileFolderPath = String.valueOf(run.getNumber());
                    File logfileFolder = new File(String.valueOf(workspace) + File.separator + logfileFolderPath);
                    if (!logfileFolder.exists() && logfileFolder.mkdirs()) {
                        System.out.println("directory " + String.valueOf(logfileFolder) + " created");
                    }
                    w = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(workspace) + File.separator + logfileFolderPath + File.separator + logfilename), "UTF-8");
                    pw = new PrintWriter(w);
                    in = null;
                    in = new BufferedReader(new InputStreamReader(resp.istream, "utf-8"));
                    while ((inputLine = in.readLine()) != null) {
                        pw.println(inputLine);
                        errormsg = this.inspectFailureInLogs(inputLine);
                        if (errormsg == null) continue;
                        run.setResult(Result.FAILURE);
                        break;
                    }
                } else {
                    if (resp.status == 401) {
                        throw new Exception();
                    }
                    if (resp.status == 503) {
                        throw new Exception();
                    }
                    throw new Exception();
                }
                in.close();
                resp.istream.close();
                pw.close();
                listener.getLogger().println("Spool file #" + i + " was successfully written to workspace");
                listener.getLogger().println("Job Output Path= " + String.valueOf(workspace) + File.separator + logfilename);
            }
            if (errormsg != null) {
                listener.getLogger().println(errormsg);
            }
        }
        catch (IOException ioex) {
            listener.getLogger().println("Job log STARTS here...");
            listener.getLogger().println();
            listener.getLogger().println(append_data.toString());
            listener.getLogger().println();
            listener.getLogger().println("Retrieved job log ends here...");
            listener.getLogger().println("Job Output Path= " + String.valueOf(workspace) + File.separator + logfilename);
            listener.getLogger().println(ioex);
            ioex.printStackTrace();
        }
        catch (Exception ex) {
            listener.getLogger().println("Error while retrieving the job log");
            listener.getLogger().println(ex);
            ex.printStackTrace();
            run.setResult(Result.FAILURE);
        }
    }

    @Extension
    @Symbol(value={"BMC DevOps for BMC AMI Change Manager for IMS TM Plugin"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private int lastEditorId = 0;

        public DescriptorImpl() {
            super(BmcDlpBuilder.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "BMC AMI DevOps for Change Manager for IMS TM";
        }

        @JavaScriptMethod
        public synchronized String createUniqueId() {
            return String.valueOf(this.lastEditorId++);
        }

        public String getId() {
            return super.getId();
        }

        @POST
        public FormValidation doCheckPswd(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"Password is required!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckServer(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"Required field!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckPort(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"Required field!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckUser(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"Required field!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckDPds(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"Required field!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckDlist(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"Required field!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckLib(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"Load library is rerquired!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckElementName(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"A name is required for this element!");
            } else if (value.length() > 8) {
                result = FormValidation.warning((String)"Element name should be 1-8 characters");
            }
            return result;
        }

        @POST
        public FormValidation doCheckPsb(@QueryParameter String value, @QueryParameter String action) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if ((action.contains("ADD") || action.contains("ADDREV")) && tempValue.isEmpty()) {
                result = FormValidation.error((String)"PSB name is required!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckAppres(@QueryParameter String value, @QueryParameter String dyn, @QueryParameter String gpsb) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.equals("Y")) {
                if (dyn.equals("Y") || dyn.equals("DOPT")) {
                    result = FormValidation.warning((String)("RES=Y and DYN=" + dyn + " are mutually exclusive"));
                } else if (gpsb.equals("Y")) {
                    result = FormValidation.warning((String)("RES=Y and GPSB=" + gpsb + " are mutually exclusive"));
                }
            }
            return result;
        }

        @POST
        public FormValidation doCheckBmcRldAreas(@QueryParameter boolean value, @QueryParameter boolean bmcAuto, @QueryParameter boolean bmcRand, @QueryParameter boolean bmcRandOnly, @QueryParameter boolean bmcIoVfExt) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value && (bmcAuto || bmcRand || bmcRandOnly || bmcIoVfExt)) {
                result = FormValidation.error((String)"If RLDAREAS is specified then no other field (except for RELGSAM and COPYACB) can be specified.");
            }
            return result;
        }

        @POST
        public FormValidation doCheckBmcIoVfExt(@QueryParameter boolean value, @QueryParameter boolean bmcAuto, @QueryParameter boolean bmcRand, @QueryParameter boolean bmcRandOnly, @QueryParameter boolean bmcRldAreas) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value && (bmcAuto || bmcRand || bmcRandOnly || bmcRldAreas)) {
                result = FormValidation.error((String)"If IOVFEXT is specified then no other field (except for RELGSAM and COPYACB) can be specified.");
            }
            return result;
        }

        @POST
        public FormValidation doCheckTy(@QueryParameter String value, @QueryParameter String appfp) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if ((value.equals("BATCH") || value.equals("BMP")) && appfp.equals("Y")) {
                result = FormValidation.warning((String)("TY=" + value + " and FP=" + appfp + " are mutually exclusive"));
            }
            return result;
        }

        @POST
        public FormValidation doCheckSchd(@QueryParameter String value, @QueryParameter String dyn) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.equals("PARALLEL") && (dyn.equals("Y") || dyn.equals("DOPT"))) {
                result = FormValidation.warning((String)("SCHD=" + value + " and DYN=" + dyn + " are mutually exclusive"));
            }
            return result;
        }

        @POST
        public FormValidation doCheckAppfp(@QueryParameter String value, @QueryParameter boolean bmcLang, @QueryParameter String lang, @QueryParameter String ty) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.equals("Y")) {
                if (lang.equals("JAVA") && bmcLang) {
                    result = FormValidation.warning((String)("FP=" + value + " and LANG=" + lang + " are mutually exclusive"));
                } else if (ty.equals("BMP") || ty.equals("BATCH")) {
                    result = FormValidation.warning((String)("FP=" + value + " and TY=" + ty + " are mutually exclusive"));
                }
            }
            return result;
        }

        @POST
        public FormValidation doCheckDyn(@QueryParameter String value, @QueryParameter String gpsb, @QueryParameter String schd, @QueryParameter String appres) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.equals("Y") || value.equals("DOPT")) {
                if (gpsb.equals("Y")) {
                    result = FormValidation.warning((String)("DYN=" + value + " and GPSB=" + gpsb + " are mutually exclusive"));
                } else if (schd.equals("PARALLEL")) {
                    result = FormValidation.warning((String)("DYN=" + value + " and SCHD=" + schd + " are mutually exclusive"));
                } else if (appres.equals("Y")) {
                    result = FormValidation.warning((String)("DYN=" + value + " and RES=" + appres + " are mutually exclusive"));
                }
            }
            return result;
        }

        @POST
        public FormValidation doCheckGpsb(@QueryParameter String value, @QueryParameter boolean bmcLang, @QueryParameter String dyn, @QueryParameter String appres) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.equals("Y")) {
                if (!bmcLang) {
                    result = FormValidation.error((String)"If GPSB=YES, LANG must be specified");
                }
                if (dyn.equals("DOPT") || dyn.equals("Y")) {
                    result = FormValidation.warning((String)("GPSB=" + value + " and DYN=" + dyn + " are mutually exclusive"));
                }
                if (appres.equals("Y")) {
                    result = FormValidation.warning((String)("GPSB=" + value + " and RES=" + appres + " are mutually exclusive"));
                }
            }
            return result;
        }

        @POST
        public FormValidation doCheckLang(@QueryParameter String value, @QueryParameter boolean bmcLang, @QueryParameter String appfp, @QueryParameter String gpsb) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (bmcLang) {
                if (gpsb.equals("N")) {
                    result = FormValidation.error((String)"LANG is only valid if GPSB=YES");
                }
                if (value.equals("JAVA") && appfp.equals("Y")) {
                    result = FormValidation.warning((String)("LANG=" + value + " and FP=" + appfp + " are mutually exclusive"));
                }
            }
            return result;
        }

        @POST
        public FormValidation doCheckBmcWfi(@QueryParameter String mper, @QueryParameter String wfi) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (wfi.equals("Y") && mper.equals("MULT")) {
                result = FormValidation.warning((String)"WFI and MPER=MULT are mutually exclusive");
            }
            return result;
        }

        @POST
        public FormValidation doCheckMseg(@QueryParameter String value, @QueryParameter String tranfp) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.equals("Y") && tranfp.equals("Y")) {
                result = FormValidation.warning((String)"Fast Path transactions must have MSEG=N (The incoming message can't contain more than one segment).");
            }
            return result;
        }

        @POST
        public FormValidation doCheckResp(@QueryParameter String value, @QueryParameter String tranfp) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (tranfp.equals("Y") && value.equals("N")) {
                result = FormValidation.warning((String)"Fast Path transactions must have RESP=Y");
            }
            return result;
        }

        @POST
        public FormValidation doCheckTraninq(@QueryParameter String value, @QueryParameter String recv) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.equals("N") && recv.equals("N")) {
                result = FormValidation.warning((String)"INQ=N and RECV=N are mutually exclusive");
            }
            return result;
        }

        @POST
        public FormValidation doCheckRecv(@QueryParameter String value, @QueryParameter String traninq, @QueryParameter String tranfp) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.equals("N")) {
                if (traninq.equals("N")) {
                    result = FormValidation.warning((String)"RECV=N and INQ=N are mutually exclusive");
                }
                if (tranfp.equals("Y")) {
                    result = FormValidation.warning((String)"RECV=N and FP=Y are mutually exclusive");
                }
            }
            return result;
        }

        @POST
        public FormValidation doCheckTranfp(@QueryParameter String value, @QueryParameter String mseg, @QueryParameter String recv, @QueryParameter String resp, @QueryParameter String spad, @QueryParameter boolean bmcSpad, @QueryParameter boolean bmcEmhs) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.equals("Y")) {
                if (mseg.equals("Y")) {
                    result = FormValidation.warning((String)"FP=Y and MSEG=Y are mutually exclusive");
                }
                if (recv.equals("N")) {
                    result = FormValidation.warning((String)"FP=Y and RECV=N are mutually exclusive");
                }
                if (resp.equals("N")) {
                    result = FormValidation.warning((String)"FP=Y and RESP=N are mutually exclusive");
                }
                if (spad.equals("STRUNC") && bmcSpad) {
                    result = FormValidation.warning((String)"FP=Y and SPAD=STRUNC are mutually exclusive");
                }
            } else if (value.equals("N") && bmcEmhs) {
                result = FormValidation.warning((String)"FP(N) and EMHS>0 are mutually exclusive");
            }
            return result;
        }

        @POST
        public FormValidation doCheckMper(@QueryParameter String value, @QueryParameter String wfi) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (wfi.equals("Y") && value.equals("MULT")) {
                result = FormValidation.warning((String)"MPER=MULT and WFI=Y are mutually exclusive");
            }
            return result;
        }

        @POST
        public FormValidation doCheckBmcRandOnly(@QueryParameter boolean value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value) {
                result = FormValidation.ok((String)"If RANDONLY is specified then no other field can be specified.");
            }
            return result;
        }

        @POST
        public FormValidation doCheckBmcspad(@QueryParameter boolean value, @QueryParameter String spad, @QueryParameter String tranfp) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value && tranfp.equals("Y") && spad.equals("STRUNC")) {
                result = FormValidation.warning((String)"FP=Y and SPAD=STRUNC are mutually exclusive");
            }
            return result;
        }

        @POST
        public FormValidation doCheckSpad(@QueryParameter String value, @QueryParameter String tranfp) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (tranfp.equals("Y") && value.equals("STRUNC")) {
                result = FormValidation.warning((String)"FP=Y and SPAD=STRUNC are mutually exclusive");
            }
            return result;
        }

        @POST
        public FormValidation doCheckEmhs(@QueryParameter String value, @QueryParameter boolean bmcEmhs, @QueryParameter String tranfp) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (bmcEmhs) {
                if (tranfp.equals("N")) {
                    result = FormValidation.warning((String)"EMHS>0 and FP(N) are mutually exclusive");
                } else if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 12 && Integer.parseInt(value) <= 30720)) {
                    result = FormValidation.error((String)"Valid range between 12-30,720");
                }
            }
            return result;
        }

        @POST
        public FormValidation doCheckNpri(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= 14)) {
                result = FormValidation.error((String)"Valid range between 0-14");
            }
            return result;
        }

        @POST
        public FormValidation doCheckLpri(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= 14)) {
                result = FormValidation.error((String)"Valid range between 0-14");
            }
            return result;
        }

        @POST
        public FormValidation doCheckLco(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 1 && Integer.parseInt(value) <= 65535)) {
                result = FormValidation.error((String)"Valid range between 1-65,535");
            }
            return result;
        }

        @POST
        public FormValidation doCheckPlc(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= 65535)) {
                result = FormValidation.error((String)"Valid range between 0-65,535");
            }
            return result;
        }

        @POST
        public FormValidation doCheckTime(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 1 && Integer.parseInt(value) <= 65535)) {
                result = FormValidation.error((String)"Valid range between 1- 65,535");
            }
            return result;
        }

        @POST
        public FormValidation doCheckPara(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            try {
                if (tempValue.toUpperCase().equals("NONE")) {
                    return result;
                }
                if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= Short.MAX_VALUE)) {
                    result = FormValidation.error((String)"Valid range between 0-32,767");
                }
            }
            catch (NumberFormatException ex) {
                result = FormValidation.error((String)"Valid range between 0-32,767");
                return result;
            }
            return result;
        }

        @POST
        public FormValidation doCheckCl(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 1 && Integer.parseInt(value) <= 999)) {
                result = FormValidation.error((String)"Valid range between 1-999");
            }
            return result;
        }

        @POST
        public FormValidation doCheckUschd(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 1 && Integer.parseInt(value) <= 4)) {
                result = FormValidation.error((String)"Valid range between 1-4");
            }
            return result;
        }

        @POST
        public FormValidation doCheckSegs(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= 65535)) {
                result = FormValidation.error((String)"Valid range between 0-65,535");
            }
            return result;
        }

        @POST
        public FormValidation doCheckOseg(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= 65535)) {
                result = FormValidation.error((String)"Valid range between 0-65,535");
            }
            return result;
        }

        @POST
        public FormValidation doCheckLsid(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 1 && Integer.parseInt(value) <= 2036)) {
                result = FormValidation.error((String)"Valid range between 1-2036");
            }
            return result;
        }

        @POST
        public FormValidation doCheckRsid(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 1 && Integer.parseInt(value) <= 2036)) {
                result = FormValidation.error((String)"Valid range between 1-2036");
            }
            return result;
        }

        @POST
        public FormValidation doCheckSpa(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 16 && Integer.parseInt(value) <= Short.MAX_VALUE)) {
                result = FormValidation.error((String)"Valid range between 16-32,767");
            }
            return result;
        }

        @POST
        public FormValidation doCheckMreg(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= 255)) {
                result = FormValidation.error((String)"Valid range between 0-255");
            }
            return result;
        }

        @POST
        public FormValidation doCheckExptm(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!(tempValue.isEmpty() || Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= 65535)) {
                result = FormValidation.error((String)"Valid range between 0-65,535");
            }
            return result;
        }

        public ListBoxModel doFillApprelgsamItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Y", "Y");
            items.add("N", "N");
            return items;
        }

        public ListBoxModel doFillDbrelgsamItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Y", "Y");
            items.add("N", "N");
            return items;
        }

        public ListBoxModel doFillAppcopyacbItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Y", "Y");
            items.add("N", "N");
            return items;
        }

        public ListBoxModel doFillDbcopyacbItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Y", "Y");
            items.add("N", "N");
            return items;
        }

        public ListBoxModel doFillJclTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("CREATE A DELTA LIST", "crtDeltaList");
            items.add("CHECK", "check");
            items.add("EXEC", "exec");
            return items;
        }

        public ListBoxModel doFillActionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("ADD", "ADD");
            items.add("REVISE", "REVISE");
            items.add("ADDREV", "ADDREV");
            items.add("DELETE", "DELETE");
            items.add("RELOAD", "RELOAD");
            items.add("EXECUTE", "EXECUTE");
            return items;
        }

        public ListBoxModel doFillElementTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("APPLCTN", "APPLCTN");
            items.add("TRANSACT", "TRANSACT");
            items.add("DATABASE", "DATABASE");
            items.add("RTCODE", "RTCODE");
            items.add("TERMINAL", "TERMINAL");
            items.add("LTERM", "LTERM");
            items.add("SUBPOOL", "SUBPOOL");
            return items;
        }

        public ListBoxModel doFillModeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("OPTIMIZE", "OPTIMIZE");
            items.add("ELEMENT", "ELEMENT");
            return items;
        }

        public ListBoxModel doFillDbresItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillAccItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("EX", "EX");
            items.add("RO", "RO");
            items.add("RD", "RD");
            items.add("UP", "UP");
            return items;
        }

        public ListBoxModel doFillAutoItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillRandItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillRandonlyItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillRldareasItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillIovfextItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillTyItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("TP", "TP");
            items.add("BATCH", "BATCH");
            items.add("MPP", "MPP");
            items.add("BMP", "BMP");
            return items;
        }

        public ListBoxModel doFillSchdItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("SERIAL", "SERIAL");
            items.add("PARALLEL", "PARALLEL");
            return items;
        }

        public ListBoxModel doFillAppfpItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillDynItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            items.add("DOPT", "DOPT");
            return items;
        }

        public ListBoxModel doFillGpsbItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillLangItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("COBOL", "COBOL");
            items.add("ASSEM", "ASSEM");
            items.add("PASCAL", "PASCAL");
            items.add("PL/I", "PL/I");
            items.add("JAVA", "JAVA");
            items.add("NONE", "NONE");
            return items;
        }

        public ListBoxModel doFillTlsItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillAppresItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillWfiItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillMsegItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillRespItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillSignItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillL61Items() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillMsgItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("SYSINFO", "SYSINFO");
            items.add("NONIOPCB", "NONIOPCB");
            return items;
        }

        public ListBoxModel doFillRtcinqItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillApptlsItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Y", "Y");
            items.add("N", "N");
            return items;
        }

        public ListBoxModel doFillTraninqItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillRecvItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Y", "Y");
            items.add("N", "N");
            return items;
        }

        public ListBoxModel doFillTranfpItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillMperItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("MULT", "MULT");
            items.add("SNGL", "SNGL");
            return items;
        }

        public ListBoxModel doFillUcItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Y", "Y");
            items.add("N", "N");
            return items;
        }

        public ListBoxModel doFillSpadItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("STRUNC", "STRUNC");
            items.add("RTRUNC", "RTRUNC");
            return items;
        }

        public ListBoxModel doFillMscItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillDcItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Y", "Y");
            items.add("N", "N");
            return items;
        }

        public ListBoxModel doFillSerItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }

        public ListBoxModel doFillAoiItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            items.add("T", "T");
            items.add("C", "C");
            return items;
        }

        public ListBoxModel doFillTrantlsItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("N", "N");
            items.add("Y", "Y");
            return items;
        }
    }
}

