/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.utils;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Result;
import hudson.plugins.blazemeter.BlazeMeterPerformanceBuilderDescriptor;
import hudson.plugins.blazemeter.BlazemeterCredential;
import hudson.plugins.blazemeter.PerformanceBuildAction;
import hudson.plugins.blazemeter.PerformanceBuilder;
import hudson.plugins.blazemeter.api.BlazemeterApi;
import hudson.plugins.blazemeter.api.BlazemeterApiV3Impl;
import hudson.plugins.blazemeter.entities.CIStatus;
import hudson.plugins.blazemeter.entities.TestStatus;
import hudson.plugins.blazemeter.testresult.TestResult;
import hudson.plugins.blazemeter.utils.Utils;
import hudson.util.FormValidation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.StdErrLog;
import org.json.JSONArray;
import org.json.JSONException;

public class BzmServiceManager {
    private static StdErrLog logger = new StdErrLog("BZM-JEN");
    private static final int DELAY = 10000;

    private BzmServiceManager() {
    }

    public static void waitForFinish(BlazemeterApi api, String testId, AbstractLogger bzmBuildLog, String session) throws InterruptedException {
        TestStatus testStatus;
        block2: {
            Date start = null;
            long lastPrint = 0L;
            do {
                Thread.sleep(15000L);
                testStatus = api.getTestStatus(session);
                if (!testStatus.equals((Object)TestStatus.Running)) break block2;
                if (start == null) {
                    start = Calendar.getInstance().getTime();
                }
                long now = Calendar.getInstance().getTime().getTime();
                long diffInSec = (now - start.getTime()) / 1000L;
                if (now - lastPrint <= 10000L) continue;
                bzmBuildLog.info("BlazeMeter test# " + testId + ", session # " + session + " running from " + start + " - for " + diffInSec + " seconds", new Object[0]);
                lastPrint = now;
            } while (!Thread.interrupted());
            bzmBuildLog.info("Job was stopped by user", new Object[0]);
            throw new InterruptedException("Job was stopped by user");
        }
        bzmBuildLog.info("TestStatus for session " + session + " " + (Object)((Object)testStatus), new Object[0]);
        bzmBuildLog.info("BlazeMeter TestStatus for session" + session + " is not 'Running': finishing build.... ", new Object[0]);
        bzmBuildLog.info("Timestamp: " + Calendar.getInstance().getTime(), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReportUrl(BlazemeterApi api, String masterId, StdErrLog jenBuildLog, StdErrLog bzmBuildLog) {
        org.json.JSONObject jo = null;
        String publicToken = "";
        String reportUrl = null;
        try {
            jo = api.generatePublicToken(masterId);
            if (jo.get("error").equals(org.json.JSONObject.NULL)) {
                org.json.JSONObject result = jo.getJSONObject("result");
                publicToken = result.getString("publicToken");
                reportUrl = api.getBlazeMeterURL() + "/app/?public-token=" + publicToken + "#masters/" + masterId + "/summary";
            }
            jenBuildLog.warn("Problems with generating public-token for report URL: " + jo.get("error").toString(), new Object[0]);
            bzmBuildLog.warn("Problems with generating public-token for report URL: " + jo.get("error").toString(), new Object[0]);
            reportUrl = api.getBlazeMeterURL() + "/app/#masters/" + masterId + "/summary";
            return reportUrl;
        }
        catch (Exception e) {
            jenBuildLog.warn("Problems with generating public-token for report URL", new Object[0]);
            bzmBuildLog.warn("Problems with generating public-token for report URL", (Throwable)e);
        }
        finally {
            return reportUrl;
        }
    }

    public static String getSessionId(org.json.JSONObject json, StdErrLog bzmBuildLog, StdErrLog jenBuildLog) throws JSONException {
        String session = "";
        try {
            org.json.JSONObject startJO = (org.json.JSONObject)json.get("result");
            session = ((JSONArray)startJO.get("sessionsId")).get(0).toString();
        }
        catch (Exception e) {
            jenBuildLog.info("Failed to get session_id: " + e.getMessage(), new Object[0]);
            bzmBuildLog.info("Failed to get session_id. ", (Throwable)e);
        }
        return session;
    }

    public static void publishReport(BlazemeterApi api, String masterId, AbstractBuild<?, ?> build, StdErrLog jenBuildLog, StdErrLog bzmBuildLog) {
        String reportUrl = BzmServiceManager.getReportUrl(api, masterId, jenBuildLog, bzmBuildLog);
        jenBuildLog.info("BlazeMeter test report will be available at " + reportUrl, new Object[0]);
        PerformanceBuildAction a = new PerformanceBuildAction(build);
        a.setReportUrl(reportUrl);
        build.addAction((Action)a);
    }

    public static void saveReport(String reportName, String report, FilePath filePath, StdErrLog jenBuildLog) {
        FilePath junit = null;
        try {
            junit = new FilePath(filePath, reportName);
            if (!junit.exists()) {
                junit.touch(System.currentTimeMillis());
            }
            junit.write(report, System.getProperty("file.encoding"));
        }
        catch (FileNotFoundException e) {
            jenBuildLog.info("ERROR: Failed to save XML report to filepath=" + junit.getParent() + "/" + junit.getName() + " : " + e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            jenBuildLog.info("ERROR: Failed to save XML report to filepath=" + filePath.getParent() + "/" + filePath.getName() + " : " + e.getMessage(), new Object[0]);
        }
        catch (InterruptedException e) {
            jenBuildLog.info("ERROR: Failed to save XML report to filepath=" + filePath.getParent() + "/" + filePath.getName() + " : " + e.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CIStatus validateCIStatus(BlazemeterApi api, String session, StdErrLog jenBuildLog) {
        CIStatus ciStatus = CIStatus.success;
        JSONArray failures = new JSONArray();
        JSONArray errors = new JSONArray();
        try {
            org.json.JSONObject jo = api.getCIStatus(session);
            jenBuildLog.info("Test status object = " + jo.toString(), new Object[0]);
            failures = jo.getJSONArray("failures");
            errors = jo.getJSONArray("errors");
        }
        catch (JSONException je) {
            jenBuildLog.warn("No thresholds on server: setting 'success' for CIStatus ", new Object[0]);
        }
        catch (Exception e) {
            jenBuildLog.warn("No thresholds on server: setting 'success' for CIStatus ", new Object[0]);
        }
        finally {
            if (errors.length() > 0) {
                jenBuildLog.info("Having errors while test status validation...", new Object[0]);
                jenBuildLog.info("Errors: " + errors.toString(), new Object[0]);
                ciStatus = CIStatus.errors;
                jenBuildLog.info("Setting CIStatus=" + CIStatus.errors.name(), new Object[0]);
                return ciStatus;
            }
            if (failures.length() > 0) {
                jenBuildLog.info("Having failures while test status validation...", new Object[0]);
                jenBuildLog.info("Failures: " + failures.toString(), new Object[0]);
                ciStatus = CIStatus.failures;
                jenBuildLog.info("Setting CIStatus=" + CIStatus.failures.name(), new Object[0]);
                return ciStatus;
            }
            jenBuildLog.info("No errors/failures while validating CIStatus: setting " + CIStatus.success.name(), new Object[0]);
        }
        return ciStatus;
    }

    public static String selectUserKeyOnId(BlazeMeterPerformanceBuilderDescriptor descriptor, String id) {
        String userKey = null;
        List<BlazemeterCredential> credentialList = descriptor.getCredentials("Global");
        if (credentialList.size() == 1) {
            userKey = credentialList.get(0).getApiKey();
        } else {
            for (BlazemeterCredential c : credentialList) {
                if (!c.getId().equals(id)) continue;
                userKey = c.getApiKey();
                break;
            }
        }
        return userKey;
    }

    public static String selectUserKeyId(BlazeMeterPerformanceBuilderDescriptor descriptor, String userKey) {
        String userKeyId = null;
        List<BlazemeterCredential> credentialList = descriptor.getCredentials("Global");
        if (credentialList.size() == 1) {
            userKeyId = credentialList.get(0).getId();
        } else {
            for (BlazemeterCredential c : credentialList) {
                if (!c.getApiKey().equals(userKey)) continue;
                userKeyId = c.getId();
                break;
            }
        }
        return userKeyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadJtlReport(BlazemeterApi api, String sessionId, FilePath filePath, StdErrLog jenBuildLog, StdErrLog bzmBuildLog) {
        org.json.JSONObject jo = api.retrieveJtlZip(sessionId);
        String dataUrl = null;
        URL url = null;
        try {
            int i;
            JSONArray data = jo.getJSONObject("result").getJSONArray("data");
            for (i = 0; i < data.length(); ++i) {
                String title = data.getJSONObject(i).getString("title");
                if (!title.equals("Zip")) continue;
                dataUrl = data.getJSONObject(i).getString("dataUrl");
                break;
            }
            url = new URL(dataUrl);
            jenBuildLog.info("Jtl url = " + url.toString() + " sessionId = " + sessionId, new Object[0]);
            bzmBuildLog.info("Jtl url = " + url.toString() + " sessionId = " + sessionId, new Object[0]);
            i = 1;
            boolean jtl = false;
            while (!jtl && i < 4) {
                try {
                    jenBuildLog.info("Downloading JTLZIP for sessionId = " + sessionId + " attemp # " + i, new Object[0]);
                    int conTo = (int)(10000.0 * Math.pow(3.0, i - 1));
                    URLConnection connection = url.openConnection();
                    connection.setConnectTimeout(conTo);
                    connection.setReadTimeout(30000);
                    InputStream input = connection.getInputStream();
                    filePath.unzipFrom(input);
                    jtl = true;
                }
                catch (Exception e) {
                    bzmBuildLog.warn("Unable to get JTLZIP from " + url + ", " + e, new Object[0]);
                }
                finally {
                    ++i;
                }
            }
            FilePath sample_jtl = new FilePath(filePath, "sample.jtl");
            FilePath bm_kpis_jtl = new FilePath(filePath, "bm-kpis.jtl");
            if (sample_jtl.exists()) {
                sample_jtl.renameTo(bm_kpis_jtl);
            }
        }
        catch (JSONException e) {
            bzmBuildLog.warn("Unable to get JTLZIP from " + url, (Throwable)e);
            jenBuildLog.warn("Unable to get JTLZIP from " + url + " " + e.getMessage(), new Object[0]);
        }
        catch (MalformedURLException e) {
            bzmBuildLog.warn("Unable to get JTLZIP from " + url, (Throwable)e);
            jenBuildLog.warn("Unable to get JTLZIP from " + url + " " + e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            bzmBuildLog.warn("Unable to get JTLZIP from " + url, (Throwable)e);
            jenBuildLog.warn("Unable to get JTLZIP from " + url + " " + e.getMessage(), new Object[0]);
        }
        catch (InterruptedException e) {
            bzmBuildLog.warn("Unable to get JTLZIP from " + url, (Throwable)e);
            jenBuildLog.warn("Unable to get JTLZIP from " + url + " " + e.getMessage(), new Object[0]);
        }
    }

    public static void downloadJtlReports(BlazemeterApi api, String masterId, FilePath filePath, StdErrLog jenBuildLog, StdErrLog bzmBuildLog) {
        List<String> sessionsIds = api.getListOfSessionIds(masterId);
        for (String s : sessionsIds) {
            FilePath jtl = new FilePath(filePath, s + "-bm-artefacts");
            BzmServiceManager.downloadJtlReport(api, s, jtl, jenBuildLog, bzmBuildLog);
        }
    }

    public static void retrieveJUNITXMLreport(BlazemeterApi api, String masterId, FilePath junitPath, StdErrLog jenBuildLog) {
        String junitReport = "";
        jenBuildLog.info("Requesting JUNIT report from server, masterId=" + masterId, new Object[0]);
        try {
            junitReport = api.retrieveJUNITXML(masterId);
            String junitName = masterId + "-" + "bm-thresholds.xml";
            jenBuildLog.info("Received Junit report from server.... masterId=" + masterId, new Object[0]);
            jenBuildLog.info("Saving it to " + junitPath + " with name=" + junitName, new Object[0]);
            BzmServiceManager.saveReport(junitName, junitReport, junitPath, jenBuildLog);
        }
        catch (Exception e) {
            jenBuildLog.warn("Problems with receiving JUNIT report from server, masterId=" + masterId + ": " + e.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result postProcess(PerformanceBuilder builder, String masterId, EnvVars envVars) throws InterruptedException {
        Thread.sleep(10000L);
        BlazemeterApi api = builder.getApi();
        StdErrLog jenBuildLog = builder.getJenBuildLog();
        CIStatus ciStatus = BzmServiceManager.validateCIStatus(api, masterId, jenBuildLog);
        if (ciStatus.equals((Object)CIStatus.errors)) {
            Result result = Result.FAILURE;
            return result;
        }
        Result result = ciStatus.equals((Object)CIStatus.failures) ? Result.FAILURE : Result.SUCCESS;
        AbstractBuild<?, ?> build = builder.getBuild();
        FilePath dfp = new FilePath(build.getWorkspace(), build.getId());
        if (builder.isGetJunit()) {
            FilePath junitPath = null;
            try {
                junitPath = Utils.resolvePath(dfp, builder.getJunitPath(), envVars);
            }
            catch (Exception e) {
                jenBuildLog.warn("Failed to resolve jtlPath: " + e.getMessage(), new Object[0]);
                jenBuildLog.warn("JTL report will be saved to workspace", new Object[0]);
                junitPath = dfp;
            }
            BzmServiceManager.retrieveJUNITXMLreport(api, masterId, junitPath, jenBuildLog);
        } else {
            jenBuildLog.info("JUNIT report won't be requested: check-box is unchecked.", new Object[0]);
        }
        Thread.sleep(30000L);
        FilePath jtlPath = null;
        if (builder.isGetJtl()) {
            if (StringUtil.isBlank((String)builder.getJtlPath())) {
                jtlPath = dfp;
            } else {
                try {
                    jtlPath = Utils.resolvePath(dfp, builder.getJtlPath(), envVars);
                    jenBuildLog.info("Will use the following path for JTL: " + jtlPath.getParent().getName() + "/" + jtlPath.getName(), new Object[0]);
                }
                catch (Exception e) {
                    jenBuildLog.warn("Failed to resolve jtlPath: " + e.getMessage(), new Object[0]);
                    jenBuildLog.warn("JTL report will be saved to workspace", new Object[0]);
                    jtlPath = dfp;
                }
                jenBuildLog.info("Will use the following path for JTL: " + jtlPath.getParent().getName() + "/" + jtlPath.getName(), new Object[0]);
            }
            BzmServiceManager.downloadJtlReports(api, masterId, jtlPath, jenBuildLog, jenBuildLog);
        } else {
            jenBuildLog.info("JTL report won't be requested: check-box is unchecked.", new Object[0]);
        }
        org.json.JSONObject testReport = BzmServiceManager.requestAggregateReport(api, jenBuildLog, masterId);
        if (testReport == null || testReport.equals("null")) {
            jenBuildLog.warn("Aggregate report is not available after 4 attempts.", new Object[0]);
            return result;
        }
        TestResult testResult = null;
        try {
            testResult = new TestResult(testReport);
            jenBuildLog.info(testResult.toString(), new Object[0]);
        }
        catch (IOException ioe) {
            jenBuildLog.info("Failed to get test result. Try to check server for it", new Object[0]);
            jenBuildLog.info("ERROR: Failed to generate TestResult: " + ioe, new Object[0]);
        }
        catch (JSONException je) {
            jenBuildLog.info("Failed to get test result. Try to check server for it", new Object[0]);
            jenBuildLog.info("ERROR: Failed to generate TestResult: " + (Object)((Object)je), new Object[0]);
        }
        finally {
            return result;
        }
    }

    public static org.json.JSONObject requestAggregateReport(BlazemeterApi api, StdErrLog jenBuildLog, String masterId) {
        org.json.JSONObject testReport = null;
        try {
            for (int retries = 1; retries < 5 && testReport == null; ++retries) {
                jenBuildLog.info("Trying to get aggregate test report from server, attempt# " + retries, new Object[0]);
                testReport = api.testReport(masterId);
                if (testReport != null) {
                    return testReport;
                }
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            jenBuildLog.info("Failed to get test report from server.", new Object[0]);
        }
        return testReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean notes(BlazemeterApi api, String masterId, String notes, StdErrLog jenBuildLog) {
        boolean note = false;
        int n = 1;
        while (!note && n < 6) {
            try {
                Thread.sleep(10000L);
                int statusCode = api.getTestMasterStatusCode(masterId);
                if (statusCode <= 20) continue;
                note = api.notes(notes, masterId);
            }
            catch (Exception e) {
                jenBuildLog.warn("Failed to PATCH notes to test report on server: masterId=" + masterId + " " + e.getMessage(), new Object[0]);
            }
            finally {
                ++n;
            }
        }
        return note;
    }

    public static JSONArray prepareSessionProperties(String sesssionProperties, EnvVars vars, StdErrLog jenBuildLog) throws JSONException {
        List<String> propList = Arrays.asList(sesssionProperties.split(","));
        JSONArray props = new JSONArray();
        StrSubstitutor strSubstr = new StrSubstitutor((Map)vars);
        jenBuildLog.info("Preparing jmeter properties for the test...", new Object[0]);
        for (String s : propList) {
            try {
                org.json.JSONObject prop = new org.json.JSONObject();
                List<String> pr = Arrays.asList(s.split("="));
                if (pr.size() > 1) {
                    prop.put("key", (Object)strSubstr.replace(pr.get(0)).trim());
                    prop.put("value", (Object)strSubstr.replace(pr.get(1)).trim());
                }
                props.put((Object)prop);
            }
            catch (Exception e) {
                jenBuildLog.warn("Failed to prepare jmeter property " + s + " for the test: " + e.getMessage(), new Object[0]);
            }
        }
        jenBuildLog.info("Prepared JSONArray of jmeter properties: " + props.toString(), new Object[0]);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stopTestSession(BlazemeterApi api, String masterId, StdErrLog jenBuildLog) {
        boolean terminate = false;
        try {
            int statusCode = api.getTestMasterStatusCode(masterId);
            if (statusCode < 100 & statusCode != 0) {
                api.terminateTest(masterId);
                terminate = true;
            }
            if (statusCode >= 100 | statusCode == -1 | statusCode == 0) {
                api.stopTest(masterId);
                terminate = false;
                return terminate;
            }
        }
        catch (Exception e) {
            jenBuildLog.warn("Error while trying to stop test with testId=" + masterId + ", " + e.getMessage(), new Object[0]);
        }
        finally {
            return terminate;
        }
    }

    public static String getVersion() {
        Properties props = new Properties();
        try {
            props.load(BzmServiceManager.class.getResourceAsStream("version.properties"));
        }
        catch (IOException ex) {
            props.setProperty("version", "N/A");
        }
        return props.getProperty("version");
    }

    public static FormValidation validateUserKey(String userKey, String blazeMeterUrl) {
        if (userKey.isEmpty()) {
            logger.warn("API key is empty: please, enter valid API key", new Object[0]);
            return FormValidation.errorWithMarkup((String)"API key is empty: please, enter valid API key");
        }
        String encryptedKey = userKey.substring(0, 4) + "..." + userKey.substring(17);
        try {
            logger.info("Validating API key started: API key=" + encryptedKey, new Object[0]);
            BlazemeterApiV3Impl bzm = new BlazemeterApiV3Impl(userKey, blazeMeterUrl);
            logger.info("Getting user details from server: serverUrl=" + blazeMeterUrl, new Object[0]);
            org.json.JSONObject u = bzm.getUser();
            JSONObject user = null;
            if (u != null) {
                user = JSONObject.fromObject((Object)u.toString());
                if (user.has("error") && !user.get("error").equals(null)) {
                    logger.warn("API key is not valid: error=" + user.get("error").toString(), new Object[0]);
                    logger.warn("User profile: " + user.toString(), new Object[0]);
                    return FormValidation.errorWithMarkup((String)("API key is not valid: error=" + user.get("error").toString()));
                }
                logger.warn("API key is valid: user e-mail=" + user.getString("mail"), new Object[0]);
                return FormValidation.ok((String)("API key Valid. Email - " + user.getString("mail")));
            }
        }
        catch (ClassCastException e) {
            logger.warn("API key is not valid: unexpected exception=" + e.getMessage().toString(), new Object[0]);
            logger.warn((Throwable)e);
        }
        catch (Exception e) {
            logger.warn("API key is not valid: unexpected exception=" + e.getMessage().toString(), new Object[0]);
            logger.warn((Throwable)e);
            return FormValidation.errorWithMarkup((String)("API key is not valid: unexpected exception=" + e.getMessage().toString()));
        }
        logger.warn("API key is not valid: userKey=" + encryptedKey + " blazemeterUrl=" + blazeMeterUrl, new Object[0]);
        logger.warn(" Please, check proxy settings, serverUrl and userKey.", new Object[0]);
        return FormValidation.error((String)("API key is not valid: API key=" + encryptedKey + " blazemeterUrl=" + blazeMeterUrl + ". Please, check proxy settings, serverUrl and userKey."));
    }

    public static String getUserEmail(String userKey, String blazemeterUrl) {
        BlazemeterApiV3Impl bzm = new BlazemeterApiV3Impl(userKey, blazemeterUrl);
        try {
            JSONObject user = JSONObject.fromObject((Object)bzm.getUser().toString());
            if (user.has("mail")) {
                return user.getString("mail");
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void properties(BlazemeterApi api, JSONArray properties, String masterId, StdErrLog jenBuildLog) {
        List<String> sessionsIds = api.getListOfSessionIds(masterId);
        jenBuildLog.info("Trying to submit jmeter properties: got " + sessionsIds.size() + " sessions", new Object[0]);
        for (String s : sessionsIds) {
            jenBuildLog.info("Submitting jmeter properties to sessionId=" + s, new Object[0]);
            int n = 1;
            boolean submit = false;
            while (!submit && n < 6) {
                try {
                    submit = api.properties(properties, s);
                    if (submit) continue;
                    jenBuildLog.warn("Failed to submit jmeter properties to sessionId=" + s + " retry # " + n, new Object[0]);
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    jenBuildLog.warn("Failed to submit jmeter properties to sessionId=" + s, (Throwable)e);
                }
                finally {
                    ++n;
                }
            }
        }
    }
}

