/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.blazemeter.BlazeMeterPerformanceBuilderDescriptor;
import hudson.plugins.blazemeter.api.BlazemeterApi;
import hudson.plugins.blazemeter.api.BlazemeterApiV3Impl;
import hudson.plugins.blazemeter.api.TestType;
import hudson.plugins.blazemeter.entities.TestStatus;
import hudson.plugins.blazemeter.utils.BzmServiceManager;
import hudson.plugins.blazemeter.utils.Utils;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.StdErrLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class PerformanceBuilder
extends Builder {
    private static StdErrLog bzmBuildLog = new StdErrLog("BZM-JEN");
    private StdErrLog jenBuildLog;
    private String jobApiKey = "";
    private String testId = "";
    private String notes = "";
    private String sessionProperties = "";
    private String jtlPath = "";
    private String junitPath = "";
    private boolean getJtl = false;
    private boolean getJunit = false;
    private BlazemeterApi api = null;
    private AbstractBuild<?, ?> build = null;
    private transient String filename;
    @Extension
    public static final BlazeMeterPerformanceBuilderDescriptor DESCRIPTOR = new BlazeMeterPerformanceBuilderDescriptor();

    @DataBoundConstructor
    public PerformanceBuilder(String jobApiKey, String testId, String notes, String sessionProperties, String jtlPath, String junitPath, boolean getJtl, boolean getJunit) {
        this.jobApiKey = BzmServiceManager.selectUserKeyOnId(DESCRIPTOR, jobApiKey);
        this.testId = testId;
        this.api = new BlazemeterApiV3Impl(jobApiKey, DESCRIPTOR.getBlazeMeterURL());
        this.jtlPath = jtlPath;
        this.junitPath = junitPath;
        this.getJtl = getJtl;
        this.getJunit = getJunit;
        this.notes = notes;
        this.sessionProperties = sessionProperties;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.build = build;
        this.jenBuildLog = new StdErrLog("BUILD-JEN");
        this.jenBuildLog.setStdErrStream(listener.getLogger());
        File bzmLogFile = new File(build.getLogFile().getParentFile(), "bzm-jen-log");
        if (!bzmLogFile.exists()) {
            FileUtils.forceMkdir((File)bzmLogFile.getParentFile());
            bzmLogFile.createNewFile();
        }
        PrintStream bzmBuildLogStream = new PrintStream(bzmLogFile);
        bzmBuildLog.setStdErrStream(bzmBuildLogStream);
        this.api = new BlazemeterApiV3Impl(this.jobApiKey, DESCRIPTOR.getBlazeMeterURL());
        this.api.setLogger(this.jenBuildLog);
        bzmBuildLog.setDebugEnabled(true);
        this.api.getBzmHttpWr().setLogger(bzmBuildLog);
        this.api.getBzmHttpWr().setLogger(bzmBuildLog);
        String userEmail = BzmServiceManager.getUserEmail(this.jobApiKey, DESCRIPTOR.getBlazeMeterURL());
        String userKeyId = BzmServiceManager.selectUserKeyId(DESCRIPTOR, this.jobApiKey);
        if (userEmail.isEmpty()) {
            ProxyConfiguration proxy = ProxyConfiguration.load();
            this.jenBuildLog.warn("Please, check that settings are valid.", new Object[0]);
            this.jenBuildLog.warn("UserKey=" + userKeyId + ", serverUrl=" + DESCRIPTOR.getBlazeMeterURL(), new Object[0]);
            this.jenBuildLog.warn("ProxyHost=" + proxy.name, new Object[0]);
            this.jenBuildLog.warn("ProxyPort=" + proxy.port, new Object[0]);
            this.jenBuildLog.warn("ProxyUser=" + proxy.getUserName(), new Object[0]);
            String proxyPass = proxy.getPassword();
            this.jenBuildLog.warn("ProxyPass=" + (StringUtils.isBlank((CharSequence)proxyPass) ? "" : proxyPass.substring(0, 3)) + "...", new Object[0]);
            return false;
        }
        this.jenBuildLog.warn("BlazeMeter plugin version =" + BzmServiceManager.getVersion(), new Object[0]);
        this.jenBuildLog.warn("User key =" + userKeyId + " is valid with " + DESCRIPTOR.getBlazeMeterURL(), new Object[0]);
        this.jenBuildLog.warn("User's e-mail=" + userEmail, new Object[0]);
        TestType testType = null;
        try {
            testType = Utils.getTestType(this.testId);
        }
        catch (Exception e) {
            this.jenBuildLog.warn("Failed to detect testType for starting test=" + e, new Object[0]);
        }
        String testId_num = Utils.getTestId(this.testId);
        this.jenBuildLog.info("TestId=" + this.testId, new Object[0]);
        this.jenBuildLog.info("Test type=" + testType.toString(), new Object[0]);
        String masterId = "";
        bzmBuildLog.info("### About to start BlazeMeter test # " + testId_num, new Object[0]);
        bzmBuildLog.info("Timestamp: " + Calendar.getInstance().getTime(), new Object[0]);
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        try {
            masterId = this.api.startTest(testId_num, testType);
            if (masterId.isEmpty()) {
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        catch (JSONException e) {
            this.jenBuildLog.warn("Unable to start test: check userKey, testId, server url.", new Object[0]);
            bzmBuildLog.warn("Exception while starting BlazeMeter Test ", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            this.jenBuildLog.warn("Unable to start test: check userKey, testId, server url.", new Object[0]);
            bzmBuildLog.warn("Exception while starting BlazeMeter Test ", (Throwable)e);
            return false;
        }
        BzmServiceManager.publishReport(this.api, masterId, build, this.jenBuildLog, bzmBuildLog);
        this.jenBuildLog.info("BlazeMeter test log will be available at " + bzmLogFile.getAbsolutePath(), new Object[0]);
        BzmServiceManager.notes(this.api, masterId, this.notes, this.jenBuildLog);
        try {
            if (!StringUtils.isBlank((CharSequence)this.sessionProperties)) {
                JSONArray props = BzmServiceManager.prepareSessionProperties(this.sessionProperties, envVars, this.jenBuildLog);
                BzmServiceManager.properties(this.api, props, masterId, this.jenBuildLog);
            }
            BzmServiceManager.waitForFinish(this.api, testId_num, (AbstractLogger)bzmBuildLog, masterId);
            bzmBuildLog.info("BlazeMeter test# " + testId_num + " was terminated at " + Calendar.getInstance().getTime(), new Object[0]);
            Result result = BzmServiceManager.postProcess(this, masterId, envVars);
            build.setResult(result);
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            this.jenBuildLog.warn("Job was stopped by user", new Object[0]);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.jenBuildLog.warn("Job was stopped due to unknown reason", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            TestStatus testStatus = this.api.getTestStatus(masterId);
            if (testStatus.equals((Object)TestStatus.Running)) {
                this.jenBuildLog.info("Shutting down test", new Object[0]);
                BzmServiceManager.stopTestSession(this.api, masterId, this.jenBuildLog);
                build.setResult(Result.ABORTED);
            } else if (testStatus.equals((Object)TestStatus.NotFound)) {
                build.setResult(Result.FAILURE);
                this.jenBuildLog.warn("Test not found error", new Object[0]);
            } else if (testStatus.equals((Object)TestStatus.Error)) {
                build.setResult(Result.FAILURE);
                this.jenBuildLog.warn("Test is not running on server. Check logs for detailed errors", new Object[0]);
            }
            FilePath bzmLogPath = new FilePath(bzmLogFile.getParentFile());
            FilePath bzmLogPathWS = new FilePath(build.getWorkspace(), build.getId());
            this.jenBuildLog.warn("Copying bzm log files to build workspace: " + bzmLogPathWS.getRemote(), new Object[0]);
            bzmLogPath.copyRecursiveTo(bzmLogPathWS);
        }
    }

    public String getJobApiKey() {
        return this.jobApiKey;
    }

    public void setJobApiKey(String jobApiKey) {
        this.jobApiKey = jobApiKey;
    }

    public String getTestId() {
        return this.testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public static StdErrLog getBzmBuildLog() {
        return bzmBuildLog;
    }

    public StdErrLog getJenBuildLog() {
        return this.jenBuildLog;
    }

    public BlazemeterApi getApi() {
        return this.api;
    }

    public boolean isGetJtl() {
        return this.getJtl;
    }

    public boolean isGetJunit() {
        return this.getJunit;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getSessionProperties() {
        return this.sessionProperties;
    }

    public String getJtlPath() {
        return this.jtlPath;
    }

    public void setJtlPath(String jtlPath) {
        this.jtlPath = jtlPath;
    }

    public String getJunitPath() {
        return this.junitPath;
    }

    public void setJunitPath(String junitPath) {
        this.junitPath = junitPath;
    }

    public void setSessionProperties(String sessionProperties) {
        this.sessionProperties = sessionProperties;
    }

    public BlazeMeterPerformanceBuilderDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends BlazeMeterPerformanceBuilderDescriptor {
        @Override
        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return super.configure(req, formData);
        }
    }
}

