/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import hudson.Extension;
import hudson.plugins.blazemeter.AbstractBlazemeterCredential;
import hudson.plugins.blazemeter.BlazeMeterPerformanceBuilderDescriptor;
import hudson.plugins.blazemeter.Messages;
import hudson.plugins.blazemeter.utils.BzmServiceManager;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import org.eclipse.jetty.util.log.StdErrLog;
import org.json.JSONException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BlazemeterCredentialImpl
extends AbstractBlazemeterCredential {
    private static final long serialVersionUID = 1L;
    private static StdErrLog logger = new StdErrLog("BZM-JEN");
    private final String apiKey;
    private final String description;

    @DataBoundConstructor
    public BlazemeterCredentialImpl(String apiKey, String description) {
        this.apiKey = apiKey;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return Messages.BlazemeterCredential_DisplayName();
        }

        public ListBoxModel doFillScopeItems() {
            ListBoxModel m = new ListBoxModel();
            m.add(CredentialsScope.GLOBAL.getDisplayName(), CredentialsScope.GLOBAL.toString());
            return m;
        }

        public FormValidation doTestConnection(@QueryParameter(value="apiKey") String userKey) throws MessagingException, IOException, JSONException, ServletException {
            BlazeMeterPerformanceBuilderDescriptor descriptor = BlazeMeterPerformanceBuilderDescriptor.getDescriptor();
            return BzmServiceManager.validateUserKey(userKey, descriptor.getBlazeMeterURL());
        }
    }
}

