/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.utils.logger;

import com.blazemeter.api.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;

public class BzmJobLogger
implements Logger {
    private java.util.logging.Logger logger = java.util.logging.Logger.getLogger(BzmJobLogger.class.getName());
    private java.util.logging.Logger fileLogger;
    private FileHandler fileHandler;

    public BzmJobLogger(String logFile) {
        File f = new File(logFile);
        this.fileLogger = java.util.logging.Logger.getLogger(f.getName());
        try {
            this.fileHandler = new FileHandler(logFile);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot create file handler for log file", ex);
        }
        this.fileHandler.setFormatter(new SimpleFormatter());
        this.fileLogger.addHandler(this.fileHandler);
        this.fileLogger.setUseParentHandlers(false);
        this.fileLogger.setLevel(Level.FINE);
    }

    public void close() {
        this.fileHandler.close();
    }

    public void debug(String s) {
        this.logger.log(Level.FINE, s);
        this.fileLogger.log(Level.FINE, s);
    }

    public void debug(String s, Throwable throwable) {
        this.logger.log(Level.FINE, s, throwable);
        this.fileLogger.log(Level.FINE, s, throwable);
    }

    public void info(String s) {
        this.logger.log(Level.INFO, s);
        this.fileLogger.log(Level.INFO, s);
    }

    public void info(String s, Throwable throwable) {
        this.logger.log(Level.INFO, s, throwable);
        this.fileLogger.log(Level.INFO, s, throwable);
    }

    public void warn(String s) {
        this.logger.log(Level.WARNING, s);
        this.fileLogger.log(Level.WARNING, s);
    }

    public void warn(String s, Throwable throwable) {
        this.logger.log(Level.WARNING, s, throwable);
        this.fileLogger.log(Level.WARNING, s, throwable);
    }

    public void error(String s) {
        this.logger.log(Level.SEVERE, s);
        this.fileLogger.log(Level.SEVERE, s);
    }

    public void error(String s, Throwable throwable) {
        this.logger.log(Level.SEVERE, s, throwable);
        this.fileLogger.log(Level.SEVERE, s, throwable);
    }
}

