/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.utils.interrupt;

import hudson.EnvVars;
import hudson.model.Run;
import hudson.remoting.VirtualChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InterruptListenerTask
extends Thread {
    protected Logger logger = Logger.getLogger(InterruptListenerTask.class.getName());
    private final int ATTEMPT_COUNT = Integer.parseInt(System.getProperty("bzm.interrupt.attemptCount", "45"));
    private final long RETRY_DELAY = Long.parseLong(System.getProperty("bzm.checkTimeout", "10000"));
    protected String jobName;
    private VirtualChannel channel;
    private Run run;
    protected boolean isDone = false;

    public InterruptListenerTask(Run run, String jobName, VirtualChannel channel) {
        this.run = run;
        this.jobName = jobName;
        this.channel = channel;
    }

    @Override
    public void run() {
        int i = 0;
        while (!this.isDone && i < this.ATTEMPT_COUNT) {
            try {
                String isInterrupted;
                this.logger.log(Level.FINE, "Check interrupt status. Attempt #" + i);
                ++i;
                EnvVars ev = EnvVars.getRemote((VirtualChannel)this.channel);
                String ruId = "isInterrupted-" + this.jobName + "-" + this.run.getId();
                if (ev != null && ev.containsKey((Object)ruId) && "true".equals(isInterrupted = ev.get(ruId, "false"))) {
                    this.isDone = true;
                    this.logger.log(Level.FINE, "Interrupt status = true. Finished.");
                    return;
                }
                Thread.sleep(this.RETRY_DELAY);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "Caught Interrupted Exception", e);
                return;
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to get isInterrupted status", e);
            }
        }
    }
}

