/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter.utils;

import com.blazemeter.api.explorer.Account;
import com.blazemeter.api.explorer.User;
import com.blazemeter.api.explorer.Workspace;
import com.blazemeter.api.explorer.test.AbstractTest;
import com.blazemeter.api.utils.BlazeMeterUtils;
import com.blazemeter.ciworkflow.TestsListFlow;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class JenkinsTestListFlow
extends TestsListFlow {
    private String limit;

    public JenkinsTestListFlow(BlazeMeterUtils utils, String limit) {
        super(utils);
        this.limit = !StringUtils.isBlank((String)limit) & StringUtils.isNumeric((String)limit) ? limit : "10000";
    }

    public List<AbstractTest> getAllTestsForWorkspaceWithException(Workspace workspace) throws Exception {
        ArrayList<AbstractTest> tests = new ArrayList<AbstractTest>();
        tests.addAll(workspace.getSingleTests(this.limit, "name"));
        tests.addAll(workspace.getMultiTests(this.limit, "name"));
        return tests;
    }

    public List<Workspace> getWorkspacesForUser(User user) {
        List accounts = null;
        try {
            accounts = user.getAccounts();
        }
        catch (Exception e) {
            this.getUtils().getNotifier().notifyError("Failed to get accounts for user with id = " + user.getId() + ". Reason is: " + e.getMessage());
        }
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        for (Account account : accounts) {
            try {
                workspaces.addAll(account.getWorkspaces());
            }
            catch (Exception e) {
                this.getUtils().getNotifier().notifyError("Failed to get workspaces for account with id = " + account.getId() + ". Reason is: " + e.getMessage());
            }
        }
        this.getUtils().getNotifier().notifyInfo("Got " + workspaces.size() + " workspaces from server.");
        return workspaces;
    }
}

