/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.blazemeter;

import com.blazemeter.api.explorer.User;
import com.blazemeter.api.explorer.Workspace;
import com.blazemeter.api.explorer.test.AbstractTest;
import com.blazemeter.api.utils.BlazeMeterUtils;
import com.cloudbees.plugins.credentials.CredentialsScope;
import hudson.Extension;
import hudson.plugins.blazemeter.BlazeMeterPerformanceBuilderDescriptor;
import hudson.plugins.blazemeter.BlazemeterCredentialsBAImpl;
import hudson.plugins.blazemeter.PerformanceBuilder;
import hudson.plugins.blazemeter.PerformanceBuilderDSLContext;
import hudson.plugins.blazemeter.utils.JenkinsBlazeMeterUtils;
import hudson.plugins.blazemeter.utils.JenkinsTestListFlow;
import hudson.plugins.blazemeter.utils.Utils;
import hudson.plugins.blazemeter.utils.logger.BzmServerLogger;
import hudson.plugins.blazemeter.utils.notifier.BzmServerNotifier;
import java.util.List;
import javaposse.jobdsl.dsl.Context;
import javaposse.jobdsl.dsl.helpers.step.StepContext;
import javaposse.jobdsl.plugin.ContextExtensionPoint;
import javaposse.jobdsl.plugin.DslExtensionMethod;
import org.apache.commons.lang3.StringUtils;

@Extension(optional=true)
public class PerformanceBuilderDSLExtension
extends ContextExtensionPoint {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DslExtensionMethod(context=StepContext.class)
    public Object blazeMeterTest(Runnable closure) {
        BzmServerLogger logger = new BzmServerLogger();
        BzmServerNotifier notifier = new BzmServerNotifier();
        logger.info("Running 'blazeMeterTest' method from JOB DSL plugin...");
        PerformanceBuilderDSLContext c = new PerformanceBuilderDSLContext();
        PerformanceBuilderDSLExtension.executeInContext((Runnable)closure, (Context)c);
        PerformanceBuilder pb = null;
        BlazeMeterPerformanceBuilderDescriptor desc = BlazeMeterPerformanceBuilderDescriptor.getDescriptor();
        String serverUrl = desc.getBlazeMeterURL();
        try {
            BlazemeterCredentialsBAImpl credential = Utils.findCredentials(c.credentialsId, CredentialsScope.GLOBAL);
            JenkinsBlazeMeterUtils bzmUtils = null;
            if (!StringUtils.isBlank((CharSequence)credential.getId())) {
                logger.info("Credentials with id = " + c.credentialsId + " are present in credentials.");
                bzmUtils = new JenkinsBlazeMeterUtils(credential.getUsername(), credential.getPassword().getPlainText(), serverUrl, notifier, logger);
                User user = null;
                try {
                    user = User.getUser((BlazeMeterUtils)bzmUtils);
                    logger.info("Credentials with id = " + c.credentialsId + " are valid.");
                }
                catch (Exception e) {
                    logger.error("Credentials with credentialsId = " + c.credentialsId + " are invalid.");
                    PerformanceBuilder performanceBuilder = pb;
                    return pb;
                }
                String limit = System.getProperty("bzm.limit", "10000");
                JenkinsTestListFlow jenkinsTestListFlow = new JenkinsTestListFlow(bzmUtils, limit);
                List<Workspace> workspaces = jenkinsTestListFlow.getWorkspacesForUser(user);
                List tests = null;
                for (Workspace workspace : workspaces) {
                    tests = jenkinsTestListFlow.getAllTestsForWorkspace(workspace);
                    for (AbstractTest t : tests) {
                        if (!t.getId().equals(c.testId)) continue;
                        pb = new PerformanceBuilder(c.credentialsId, workspace.getId(), serverUrl, c.testId, c.notes, c.sessionProperties, c.jtlPath, c.junitPath, c.getJtl, c.getJunit);
                        pb.setReportLinkName(c.reportLinkName);
                        pb.setMainTestFile(c.mainTestFile);
                        pb.setAdditionalTestFiles(c.additionalTestFiles);
                        logger.info("PerformanceBuilder was successfully created for test = " + c.testId + " in workspace = " + workspace.getId());
                    }
                }
            } else {
                logger.info(c.credentialsId + " is not present in credentials");
                PerformanceBuilder performanceBuilder = pb;
                return performanceBuilder;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to create PerformanceBuilder object from Job DSL description: credentialsId=" + c.credentialsId + ", testId =" + c.testId + ", serverUrl=" + serverUrl);
        }
        finally {
            return pb;
        }
    }
}

